from numbers import Rational as _Rational
from typing import (Any as _Any,
                    Optional as _Optional,
                    Tuple as _Tuple,
                    Union as _Union,
                    overload as _overload)

__version__: str = ...


class Endianness:
    BIG: 'Endianness' = ...
    LITTLE: 'Endianness' = ...

    def __repr__(self) -> str:
        ...


class TieBreaking:
    AWAY_FROM_ZERO: 'TieBreaking' = ...
    TO_EVEN: 'TieBreaking' = ...
    TO_ODD: 'TieBreaking' = ...
    TOWARD_ZERO: 'TieBreaking' = ...

    def __repr__(self) -> str:
        ...


class Int:
    @property
    def denominator(self) -> 'Int':
        ...

    @property
    def numerator(self) -> 'Int':
        ...

    def bit_length(self) -> 'Int':
        ...

    def gcd(self, other: 'Int') -> 'Int':
        ...

    def to_bytes(self, endianness: Endianness) -> bytes:
        ...

    @classmethod
    def from_bytes(cls, value: bytes, endianness: Endianness) -> 'Int':
        ...

    @_overload
    def __new__(cls, _value: _Union['Int', int] = ...) -> 'Int':
        ...

    @_overload
    def __new__(cls, _value: str, _base: _Optional[int] = ...) -> 'Int':
        ...

    def __abs__(self) -> 'Int':
        ...

    def __add__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __and__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __bool__(self) -> bool:
        ...

    def __ceil__(self) -> 'Int':
        ...

    def __divmod__(self, other: _Union['Int', int]) -> _Tuple['Int', 'Int']:
        ...

    @_overload
    def __eq__(self, other: 'Int') -> bool:
        ...

    @_overload
    def __eq__(self, other: _Any) -> _Any:
        ...

    def __float__(self) -> float:
        ...

    def __floor__(self) -> 'Int':
        ...

    def __floordiv__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __ge__(self, other: 'Int') -> bool:
        ...

    def __getstate__(self) -> int:
        ...

    def __gt__(self, other: 'Int') -> bool:
        ...

    def __hash__(self) -> int:
        ...

    def __invert__(self) -> 'Int':
        ...

    def __int__(self) -> int:
        ...

    def __le__(self, other: 'Int') -> bool:
        ...

    def __lshift__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __lt__(self, other: 'Int') -> bool:
        ...

    def __mod__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __mul__(self, other: 'Int') -> 'Int':
        ...

    def __neg__(self) -> 'Int':
        ...

    def __or__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __pos__(self) -> 'Int':
        ...

    def __pow__(self,
                exponent: _Union['Int', int],
                divisor: _Union['Int', None, int] = ...
                ) -> _Union['Fraction', 'Int']:
        ...

    def __radd__(self, other: int) -> Int:
        ...

    def __rand__(self, other: int) -> Int:
        ...

    def __rdivmod__(self, other: int) -> _Tuple['Int', 'Int']:
        ...

    def __repr__(self) -> str:
        ...

    def __rfloordiv__(self, other: int) -> 'Int':
        ...

    def __rlshift__(self, other: int) -> 'Int':
        ...

    def __rmod__(self, other: int) -> 'Int':
        ...

    def __rmul__(self, other: int) -> 'Int':
        ...

    def __ror__(self, other: int) -> 'Int':
        ...

    def __round__(self, digits: _Optional[int] = ...) -> 'Int':
        ...

    def __rpow__(self,
                 base: int,
                 divisor: _Union['Int', None, int] = ...
                 ) -> _Union['Fraction', 'Int']:
        ...

    def __rrshift__(self, other: int) -> 'Int':
        ...

    def __rshift__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __rsub__(self, other: int) -> 'Int':
        ...

    def __rtruediv__(self, other: int) -> 'Fraction':
        ...

    def __rxor__(self, other: int) -> 'Int':
        ...

    def __setstate__(self, state: int) -> None:
        ...

    def __str__(self) -> str:
        ...

    def __sub__(self, other: _Union['Int', int]) -> 'Int':
        ...

    def __truediv__(self, other: _Union['Int', int]) -> 'Fraction':
        ...

    def __trunc__(self) -> 'Int':
        ...

    def __xor__(self, other: _Union['Int', int]) -> 'Int':
        ...


class Fraction:
    @property
    def denominator(self) -> Int:
        ...

    @property
    def numerator(self) -> Int:
        ...

    def round(self, tie_breaking: TieBreaking) -> Int:
        ...

    @_overload
    def __new__(cls,
                _value: _Union['Fraction', Int, _Rational, float, int] = ...
                ) -> 'Fraction':
        ...

    @_overload
    def __new__(cls,
                _numerator: _Union[Int, int],
                _denominator: _Union[Int, int]) -> 'Fraction':
        ...

    def __abs__(self) -> 'Fraction':
        ...

    def __add__(self, other: _Union['Fraction', Int, int]) -> 'Fraction':
        ...

    def __bool__(self) -> bool:
        ...

    def __ceil__(self) -> 'Int':
        ...

    def __divmod__(self, divisor: _Union['Fraction', Int, int]
                   ) -> _Tuple[Int, 'Fraction']:
        ...

    @_overload
    def __eq__(self, other: _Union['Fraction', Int, int]) -> bool:
        ...

    @_overload
    def __eq__(self, other: _Any) -> _Any:
        ...

    def __float__(self) -> float:
        ...

    def __floor__(self) -> 'Int':
        ...

    def __floordiv__(self, divisor: _Union['Fraction', Int, int]) -> Int:
        ...

    def __ge__(self, other: _Union['Fraction', Int, int]) -> bool:
        ...

    def __getstate__(self) -> _Tuple[Int, Int]:
        ...

    def __gt__(self, other: _Union['Fraction', Int, int]) -> bool:
        ...

    def __le__(self, other: _Union['Fraction', Int, int]) -> bool:
        ...

    def __lt__(self, other: _Union['Fraction', Int, int]) -> bool:
        ...

    def __mod__(self, divisor: _Union['Fraction', Int, int]) -> 'Fraction':
        ...

    def __mul__(self, other: _Union['Fraction', Int, int]) -> 'Fraction':
        ...

    def __neg__(self) -> 'Fraction':
        ...

    def __pos__(self) -> 'Fraction':
        ...

    def __pow__(self, exponent: _Union['Int', int], divisor: None = ...
                ) -> 'Fraction':
        ...

    def __radd__(self, other: _Union[Int, int]) -> 'Fraction':
        ...

    def __rdivmod__(self, dividend: _Union[Int, int]
                    ) -> _Tuple[Int, 'Fraction']:
        ...

    def __repr__(self) -> str:
        ...

    def __rfloordiv__(self, dividend: _Union[Int, int]) -> Int:
        ...

    def __rmod__(self, dividend: _Union[Int, int]) -> 'Fraction':
        ...

    def __rmul__(self, other: _Union[Int, int]) -> 'Fraction':
        ...

    @_overload
    def __round__(self, digits: None = ...) -> Int:
        ...

    @_overload
    def __round__(self, digits: int) -> 'Fraction':
        ...

    def __rsub__(self, subtrahend: _Union[Int, int]) -> 'Fraction':
        ...

    def __setstate__(self, state: _Tuple[Int, Int]) -> None:
        ...

    def __str__(self) -> str:
        ...

    def __sub__(self, minuend: _Union['Fraction', Int, int]) -> 'Fraction':
        ...

    def __rtruediv__(self, dividend: _Union[Int, int]) -> 'Fraction':
        ...

    def __truediv__(self, divisor: _Union['Fraction', Int, int]) -> 'Fraction':
        ...

    def __trunc__(self) -> Int:
        ...
