// Copyright 2022 Risc0, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

use lazy_static::lazy_static;

use risc0_zkp_verify::taps::{Combo, Register, RegisterGroup, Taps};

lazy_static! {
    pub static ref RISCV_TAPS: Taps = {
        Taps {
            registers: vec![
                Register {
                    group: RegisterGroup::Accum,
                    offset: 0,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 1,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 2,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 3,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 4,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 5,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 6,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 7,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 8,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Accum,
                    offset: 9,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 0,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 1,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 2,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 3,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 4,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 5,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 6,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 7,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 8,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 9,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 10,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 11,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 12,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 13,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 14,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Code,
                    offset: 15,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 0,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 1,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 2,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 3,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 4,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 5,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 6,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 7,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 8,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 9,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 10,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 11,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 12,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 13,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 14,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 15,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 16,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 17,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 18,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 19,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 20,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 21,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 22,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 23,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 24,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 25,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 26,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 27,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 28,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 29,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 30,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 31,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 32,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 33,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 34,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 35,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 36,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 37,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 38,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 39,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 40,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 41,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 42,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 43,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 44,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 45,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 46,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 47,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 48,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 49,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 50,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 51,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 52,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 53,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 54,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 55,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 56,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 57,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 58,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 59,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 60,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 61,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 62,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 63,
                    back: vec![0, 1, 2, 3, 4, 68],
                    combo_id: 2,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 64,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 65,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 66,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 67,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 68,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 69,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 70,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 71,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 72,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 73,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 74,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 75,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 76,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 77,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 78,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 79,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 80,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 81,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 82,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 83,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 84,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 85,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 86,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 87,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 88,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 89,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 90,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 91,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 92,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 93,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 94,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 95,
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                    combo_id: 3,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 96,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 97,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 98,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 99,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 100,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 101,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 102,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 103,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 104,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 105,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 106,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 107,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 108,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 109,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 110,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 111,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 112,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 113,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 114,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 115,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 116,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 117,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 118,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 119,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 120,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 121,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 122,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 123,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 124,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 125,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 126,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 127,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 128,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 129,
                    back: vec![0, 4],
                    combo_id: 4,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 130,
                    back: vec![0, 4],
                    combo_id: 4,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 131,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 132,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 133,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 134,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 135,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 136,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 137,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 138,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 139,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 140,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 141,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 142,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 143,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 144,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 145,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 146,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 147,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 148,
                    back: vec![0, 1],
                    combo_id: 1,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 149,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 150,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 151,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 152,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 153,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 154,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 155,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 156,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 157,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 158,
                    back: vec![0],
                    combo_id: 0,
                },
                Register {
                    group: RegisterGroup::Data,
                    offset: 159,
                    back: vec![0],
                    combo_id: 0,
                },
            ],
            combos: vec![
                Combo { back: vec![0] },
                Combo { back: vec![0, 1] },
                Combo {
                    back: vec![0, 1, 2, 3, 4, 68],
                },
                Combo {
                    back: vec![0, 1, 2, 3, 7, 15, 16],
                },
                Combo { back: vec![0, 4] },
            ],
        }
    };
}
