use std::{env, fs, path::Path};

use risc0_zkvm_platform::LINKER_SCRIPT;

fn main() {
    let out_dir = env::var_os("OUT_DIR").unwrap();
    let linker_script = Path::new(&out_dir).join("risc0.ld");
    fs::write(&linker_script, LINKER_SCRIPT).unwrap();
    let linker_script = linker_script.to_str().unwrap();
    println!("cargo:rustc-link-arg=-T{linker_script}");
}
