// while GCC invoked by RIOT finds the newlib definitions, CLANG does not.
//
// This workaround fixes the fallout (that each time a *timespec is used, a
// `struct timespec` is generated by bindgen); actual solutions might be
// passing on the CC from the RIOT build system.
#ifndef BOARD_NATIVE
struct timespec { char *_unknown;};
#endif

// Copied over from newlib's stdatomic.h -- not sure why it's not included, but
// that's currently needed to get mutexes to build.
#include <stdint.h>
typedef _Atomic(int_least16_t)      atomic_int_least16_t;

// Workarounds for https://github.com/rust-lang/rust-bindgen/issues/1636
// (only needed when building for cortex using toolchain=llvm)
#define UINT16_MAX 0xffff
#define UINT32_MAX 0xffffffff

#include "riot-headers.h"
