ring_buffer
===========
[![pipeline status](https://git.h3n.eu/Kulasko/ring_buffer/badges/master/pipeline.svg)](https://git.h3n.eu/Kulasko/ring_buffer/-/commits/master)

`RingBuffer` is a mix of a vector and a queue. It allows for direct element
access as well as pushing and popping elements like a queue.

## Example

```rust
use ringbuffer::RingBuffer;

fn main() {
    let mut buffer = RingBuffer::new();
    
    let first_index = buffer.push(42);
    let second_index = buffer.push(9001);
    
    println!("{} == {}", buffer.get_relative(0),
        buffer.get_absolute(first_index));
    
    println!("{} == {}", buffer.get_relative(1),
        buffer.get_absolute(second_index));
}
```

## Why use this?

The features of RingBuffer come in handy when processing a stream of elements
while also needing to access elements at random.

#### License

<sup>
Licensed under either of <a href="LICENSE-APACHE">Apache License, Version
2.0</a> or <a href="LICENSE-MIT">MIT license</a> at your option.
</sup>

<br>

<sub>
Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in this crate by you, as defined in the Apache-2.0 license, shall
be dual licensed as above, without any additional terms or conditions.
</sub>