use anyhow::Error;
use rillrate::{Counter, RillRate};
use std::sync::{
    atomic::{AtomicBool, Ordering},
    Arc,
};
use std::thread;
use std::time::Duration;

fn main() -> Result<(), Error> {
    env_logger::try_init()?;
    let _rillrate = RillRate::from_env("my-app")?;
    let counter = Counter::create("counter")?;

    // TODO: DRY it
    let running = Arc::new(AtomicBool::new(true));
    let r = running.clone();
    ctrlc::set_handler(move || {
        r.store(false, Ordering::SeqCst);
    })?;

    while running.load(Ordering::SeqCst) {
        counter.inc(1.0);
        thread::sleep(Duration::from_millis(500));
    }
    Ok(())
}
