use reqwest::Certificate;

// this is riot games offical API certificate, you can verify it here: https://static.developer.riotgames.com/docs/lol/riotgames.pem
const RIOT_GAMES_CERT: [u8; 1492] = [45, 45, 45, 45, 45, 66, 69, 71, 73, 78, 32, 67, 69, 82, 84, 73, 70, 73, 67, 65, 84, 69, 45, 45, 45, 45, 45, 10, 77, 73, 73, 69, 73, 68, 67, 67, 65, 119, 103, 67, 67, 81, 68, 74, 67, 43, 81, 65, 100, 86, 120, 52, 85, 68, 65, 78, 66, 103, 107, 113, 104, 107, 105, 71, 57, 119, 48, 66, 65, 81, 85, 70, 65, 68, 67, 66, 48, 84, 69, 76, 77, 65, 107, 71, 65, 49, 85, 69, 66, 104, 77, 67, 10, 86, 86, 77, 120, 69, 122, 65, 82, 66, 103, 78, 86, 66, 65, 103, 84, 67, 107, 78, 104, 98, 71, 108, 109, 98, 51, 74, 117, 97, 87, 69, 120, 70, 84, 65, 84, 66, 103, 78, 86, 66, 65, 99, 84, 68, 70, 78, 104, 98, 110, 82, 104, 73, 69, 49, 118, 98, 109, 108, 106, 89, 84, 69, 84, 10, 77, 66, 69, 71, 65, 49, 85, 69, 67, 104, 77, 75, 85, 109, 108, 118, 100, 67, 66, 72, 89, 87, 49, 108, 99, 122, 69, 100, 77, 66, 115, 71, 65, 49, 85, 69, 67, 120, 77, 85, 84, 71, 57, 77, 73, 69, 100, 104, 98, 87, 85, 103, 82, 87, 53, 110, 97, 87, 53, 108, 90, 88, 74, 112, 10, 98, 109, 99, 120, 77, 122, 65, 120, 66, 103, 78, 86, 66, 65, 77, 84, 75, 107, 120, 118, 84, 67, 66, 72, 89, 87, 49, 108, 73, 69, 86, 117, 90, 50, 108, 117, 90, 87, 86, 121, 97, 87, 53, 110, 73, 69, 78, 108, 99, 110, 82, 112, 90, 109, 108, 106, 89, 88, 82, 108, 73, 69, 70, 49, 10, 100, 71, 104, 118, 99, 109, 108, 48, 101, 84, 69, 116, 77, 67, 115, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 74, 65, 82, 89, 101, 90, 50, 70, 116, 90, 88, 82, 108, 89, 50, 104, 117, 98, 50, 120, 118, 90, 50, 108, 108, 99, 48, 66, 121, 97, 87, 57, 48, 90, 50, 70, 116, 10, 90, 88, 77, 117, 89, 50, 57, 116, 77, 66, 52, 88, 68, 84, 69, 122, 77, 84, 73, 119, 78, 68, 65, 119, 78, 68, 103, 122, 79, 86, 111, 88, 68, 84, 81, 122, 77, 84, 69, 121, 78, 122, 65, 119, 78, 68, 103, 122, 79, 86, 111, 119, 103, 100, 69, 120, 67, 122, 65, 74, 66, 103, 78, 86, 10, 66, 65, 89, 84, 65, 108, 86, 84, 77, 82, 77, 119, 69, 81, 89, 68, 86, 81, 81, 73, 69, 119, 112, 68, 89, 87, 120, 112, 90, 109, 57, 121, 98, 109, 108, 104, 77, 82, 85, 119, 69, 119, 89, 68, 86, 81, 81, 72, 69, 119, 120, 84, 89, 87, 53, 48, 89, 83, 66, 78, 98, 50, 53, 112, 10, 89, 50, 69, 120, 69, 122, 65, 82, 66, 103, 78, 86, 66, 65, 111, 84, 67, 108, 74, 112, 98, 51, 81, 103, 82, 50, 70, 116, 90, 88, 77, 120, 72, 84, 65, 98, 66, 103, 78, 86, 66, 65, 115, 84, 70, 69, 120, 118, 84, 67, 66, 72, 89, 87, 49, 108, 73, 69, 86, 117, 90, 50, 108, 117, 10, 90, 87, 86, 121, 97, 87, 53, 110, 77, 84, 77, 119, 77, 81, 89, 68, 86, 81, 81, 68, 69, 121, 112, 77, 98, 48, 119, 103, 82, 50, 70, 116, 90, 83, 66, 70, 98, 109, 100, 112, 98, 109, 86, 108, 99, 109, 108, 117, 90, 121, 66, 68, 90, 88, 74, 48, 97, 87, 90, 112, 89, 50, 70, 48, 10, 90, 83, 66, 66, 100, 88, 82, 111, 98, 51, 74, 112, 100, 72, 107, 120, 76, 84, 65, 114, 66, 103, 107, 113, 104, 107, 105, 71, 57, 119, 48, 66, 67, 81, 69, 87, 72, 109, 100, 104, 98, 87, 86, 48, 90, 87, 78, 111, 98, 109, 57, 115, 98, 50, 100, 112, 90, 88, 78, 65, 99, 109, 108, 118, 10, 100, 71, 100, 104, 98, 87, 86, 122, 76, 109, 78, 118, 98, 84, 67, 67, 65, 83, 73, 119, 68, 81, 89, 74, 75, 111, 90, 73, 104, 118, 99, 78, 65, 81, 69, 66, 66, 81, 65, 68, 103, 103, 69, 80, 65, 68, 67, 67, 65, 81, 111, 67, 103, 103, 69, 66, 65, 75, 111, 74, 101, 109, 70, 47, 10, 54, 80, 78, 71, 51, 71, 82, 74, 71, 98, 106, 122, 73, 109, 84, 100, 79, 111, 49, 79, 74, 82, 68, 73, 55, 110, 111, 82, 119, 74, 103, 68, 113, 107, 97, 74, 70, 107, 119, 118, 48, 88, 56, 97, 80, 85, 71, 98, 90, 83, 85, 122, 85, 79, 50, 51, 99, 81, 99, 67, 103, 112, 89, 106, 10, 50, 49, 121, 103, 122, 75, 117, 53, 100, 116, 67, 78, 50, 69, 99, 81, 86, 86, 112, 78, 116, 121, 80, 117, 77, 50, 86, 52, 101, 69, 71, 114, 49, 119, 111, 111, 100, 122, 65, 76, 116, 117, 102, 76, 51, 78, 108, 121, 104, 54, 103, 53, 106, 75, 75, 117, 68, 73, 102, 101, 85, 66, 72, 118, 10, 74, 78, 121, 81, 102, 50, 104, 51, 85, 104, 97, 49, 54, 108, 110, 114, 88, 109, 122, 57, 111, 57, 119, 115, 88, 47, 106, 102, 43, 106, 85, 65, 108, 106, 66, 74, 113, 115, 77, 101, 65, 67, 79, 112, 88, 102, 117, 90, 121, 43, 89, 75, 85, 67, 120, 83, 80, 79, 90, 97, 89, 84, 76, 67, 10, 121, 43, 48, 71, 81, 102, 105, 84, 52, 51, 49, 112, 74, 72, 66, 81, 108, 114, 88, 65, 85, 119, 122, 79, 109, 97, 74, 80, 81, 55, 77, 54, 109, 76, 102, 115, 110, 112, 72, 105, 98, 83, 107, 120, 85, 102, 77, 102, 72, 82, 79, 97, 89, 67, 90, 47, 115, 98, 87, 75, 108, 51, 108, 114, 10, 90, 65, 57, 68, 98, 119, 97, 75, 75, 102, 83, 49, 73, 119, 48, 117, 99, 65, 101, 68, 117, 100, 121, 117, 113, 98, 52, 74, 110, 116, 71, 85, 47, 87, 48, 97, 98, 111, 75, 65, 48, 99, 51, 89, 66, 48, 50, 109, 120, 65, 77, 52, 111, 68, 110, 113, 115, 101, 117, 75, 86, 47, 67, 88, 10, 56, 83, 81, 65, 105, 97, 88, 110, 89, 111, 116, 117, 78, 88, 77, 67, 65, 119, 69, 65, 65, 84, 65, 78, 66, 103, 107, 113, 104, 107, 105, 71, 57, 119, 48, 66, 65, 81, 85, 70, 65, 65, 79, 67, 65, 81, 69, 65, 102, 51, 75, 80, 109, 100, 100, 113, 69, 113, 113, 67, 56, 105, 76, 115, 10, 108, 99, 100, 48, 101, 117, 67, 52, 70, 53, 43, 85, 83, 112, 57, 89, 115, 114, 90, 51, 87, 117, 79, 122, 72, 113, 86, 120, 84, 116, 88, 51, 104, 82, 49, 115, 99, 100, 108, 68, 88, 78, 118, 114, 115, 101, 98, 81, 90, 85, 113, 119, 71, 100, 90, 71, 77, 83, 49, 54, 108, 110, 51, 107, 10, 87, 79, 98, 119, 55, 66, 98, 104, 85, 56, 57, 116, 68, 78, 67, 78, 55, 76, 116, 47, 73, 106, 84, 52, 77, 71, 82, 89, 82, 69, 43, 84, 109, 82, 99, 53, 69, 101, 73, 88, 120, 72, 107, 81, 55, 56, 98, 81, 113, 98, 109, 65, 73, 51, 71, 115, 87, 43, 55, 107, 74, 115, 111, 79, 10, 113, 51, 68, 100, 101, 69, 43, 77, 43, 66, 85, 74, 114, 104, 87, 111, 114, 115, 65, 81, 67, 103, 85, 121, 90, 79, 49, 54, 54, 83, 65, 116, 75, 88, 75, 76, 73, 99, 120, 97, 43, 100, 100, 67, 52, 57, 78, 118, 77, 81, 80, 74, 121, 122, 109, 51, 86, 43, 50, 98, 49, 114, 111, 80, 10, 83, 118, 68, 50, 87, 86, 56, 103, 82, 89, 85, 110, 71, 109, 121, 47, 78, 48, 43, 117, 54, 65, 78, 113, 53, 69, 115, 98, 104, 90, 53, 52, 56, 122, 90, 99, 43, 66, 73, 52, 117, 112, 115, 87, 67, 104, 84, 76, 121, 120, 116, 50, 82, 120, 82, 55, 43, 117, 71, 108, 83, 49, 43, 53, 10, 69, 99, 71, 102, 75, 90, 43, 103, 48, 50, 52, 107, 47, 74, 51, 50, 88, 80, 52, 104, 100, 104, 111, 55, 87, 89, 65, 83, 50, 120, 77, 105, 86, 56, 51, 67, 102, 76, 82, 47, 77, 78, 105, 56, 111, 83, 77, 97, 86, 81, 84, 100, 75, 68, 56, 99, 112, 103, 105, 87, 74, 107, 51, 76, 10, 88, 87, 101, 104, 87, 65, 61, 61, 10, 45, 45, 45, 45, 45, 69, 78, 68, 32, 67, 69, 82, 84, 73, 70, 73, 67, 65, 84, 69, 45, 45, 45, 45, 45];

pub fn get_certificate() -> Certificate {
    return Certificate::from_pem(RIOT_GAMES_CERT.as_ref()).unwrap();
}