use super::FixedPalette;

/// 64 color palette established by the full-color EGA standard.
pub static PALETTE_EGA_6BIT: FixedPalette<&[[u8; 3]]> = FixedPalette(EGA_6BIT);

/// 64 color palette established by the full-color EGA standard.
pub static EGA_6BIT: &[[u8; 3]] = &[
    [0, 0, 0],       // CGA 0
    [0, 0, 0xAA],    // CGA 1
    [0, 0xAA, 0],    // CGA 2
    [0, 0xAA, 0xAA], // CGA 3
    [0xAA, 0, 0],    // CGA 4
    [0xAA, 0, 0xAA], // CGA 5
    [0xAA, 0xAA, 0],
    [0xAA, 0xAA, 0xAA], // CGA 7
    [0, 0, 0x55],
    [0, 0, 0xFF],
    [0, 0xAA, 0x55],
    [0, 0xAA, 0xFF],
    [0xAA, 0, 0x55],
    [0xAA, 0, 0xFF],
    [0xAA, 0xAA, 0x55],
    [0xAA, 0xAA, 0xFF],
    [0, 0x55, 0],
    [0, 0x55, 0xAA],
    [0, 0xFF, 0],
    [0, 0xFF, 0xAA],
    [0xAA, 0x55, 0], // CGA 6
    [0xAA, 0x55, 0xAA],
    [0xAA, 0xFF, 0x00],
    [0xAA, 0xFF, 0xAA],
    [0, 0x55, 0x55],
    [0, 0x55, 0xFF],
    [0, 0xFF, 0x55],
    [0, 0xFF, 0xFF],
    [0xAA, 0x55, 0x55],
    [0xAA, 0x55, 0xFF],
    [0xAA, 0xFF, 0x55],
    [0xAA, 0xFF, 0xFF],
    [0x55, 0, 0],
    [0x55, 0, 0xAA],
    [0x55, 0xAA, 0],
    [0x55, 0xAA, 0xAA],
    [0xFF, 0, 0],
    [0xFF, 0, 0xAA],
    [0xFF, 0xAA, 0],
    [0xFF, 0xAA, 0xAA],
    [0x55, 0, 0x55],
    [0x55, 0, 0xFF],
    [0x55, 0xAA, 0x55],
    [0x55, 0xAA, 0xFF],
    [0xFF, 0, 0x55],
    [0xFF, 0, 0xFF],
    [0xFF, 0xAA, 0x55],
    [0xFF, 0xAA, 0xFF],
    [0x55, 0x55, 0],
    [0x55, 0x55, 0xAA],
    [0x55, 0xFF, 0],
    [0x55, 0xFF, 0xAA],
    [0xFF, 0x55, 0],
    [0xFF, 0x55, 0xAA],
    [0xFF, 0xFF, 0x00],
    [0xFF, 0xFF, 0xAA],
    [0x55, 0x55, 0x55], // CGA 8
    [0x55, 0x55, 0xFF], // CGA 9
    [0x55, 0xFF, 0x55], // CGA 10
    [0x55, 0xFF, 0xFF], // CGA 11
    [0xFF, 0x55, 0x55], // CGA 12
    [0xFF, 0x55, 0xFF], // CGA 13
    [0xFF, 0xFF, 0x55], // CGA 14
    [0xFF, 0xFF, 0xFF], // CGA 15
];
