#[cfg(feature = "moz_central")]
extern crate rayon;
mod common;

#[test]
fn everything_js_es5() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("./node_modules/everything.js/es5.js")
        .expect("Failed to read js file");
    common::round_trip_validate(&js, false, "everything.es5").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("everything.es5", &first, &second);
}

#[test]
fn everything_js_es2015_script() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("./node_modules/everything.js/es2015-script.js")
        .expect("failed to read js file");
    common::round_trip_validate(&js, false, "everything.es2015-script").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("everything.es2015-script", &first, &second);
}

#[test]
fn everything_js_es2015_module() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("./node_modules/everything.js/es2015-module.js")
        .expect("failed to read js file");
    common::round_trip_validate(&js, true, "everything.es2015-module").unwrap();
    let (first, second) = common::double_round_trip(&js, true);
    check_round_trips("everything.es2015-module", &first, &second);
}

#[test]
fn jquery() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("./node_modules/jquery/dist/jquery.js")
        .expect("failed to read js file");
    common::round_trip_validate(&js, false, "jquery").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("jquery", &first, &second);
}

#[test]
fn angular() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("./node_modules/angular/angular.js")
        .expect("failed to read js file");
    common::round_trip_validate(&js, false, "angular").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("angular", &first, &second);
}

#[test]
fn react() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("node_modules/react/cjs/react.development.js")
        .expect("failed to read js file");
    common::round_trip_validate(&js, false, "react").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("react", &first, &second);
}
#[test]
fn react_dom() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("node_modules/react-dom/cjs/react-dom.development.js")
        .expect("failed to read js file");
    common::round_trip_validate(&js, false, "react_dom").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("react_dom", &first, &second);
}

#[test]
fn vue() {
    ensure_libraries();
    let js =
        ::std::fs::read_to_string("node_modules/vue/dist/vue.js").expect("failed to read js file");
    common::round_trip_validate(&js, false, "vue").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("vue", &first, &second);
}

#[test]
fn dexie() {
    ensure_libraries();
    let js = ::std::fs::read_to_string("node_modules/dexie/dist/dexie.js")
        .expect("failed to read js file");
    common::round_trip_validate(&js, false, "dexie").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("dexie", &first, &second);
}

#[test]
fn moment() {
    ensure_libraries();
    let js =
        ::std::fs::read_to_string("node_modules/moment/moment.js").expect("failed to read js file");
    common::round_trip_validate(&js, false, "moment").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("moment", &first, &second);
}

#[test]
fn lodash() {
    ensure_libraries();
    let js =
        ::std::fs::read_to_string("node_modules/lodash/lodash.js").expect("failed to read js file");
    common::round_trip_validate(&js, false, "lodash").unwrap();
    let (first, second) = common::double_round_trip(&js, false);
    check_round_trips("lodash", &first, &second);
}

fn write_failure(name: &str, first: &str, second: &str) {
    use std::io::Write;
    let mut f1 = ::std::fs::File::create(&format!("test_failures/{}.first.js", name))
        .expect("Failed to create first failure file");
    f1.write_all(first.as_bytes())
        .expect("failed to write to first failure file");
    let mut f2 = ::std::fs::File::create(&format!("test_failures/{}.second.js", name))
        .expect("Failed to create second failure file");
    f2.write_all(second.as_bytes())
        .expect("failed to write second failure file");
}

fn ensure_libraries() {
    if !::std::path::PathBuf::from("node_modules").exists() {
        let output = ::std::process::Command::new("npm")
            .arg("i")
            .output()
            .expect("failed to execute npm i");
        assert!(output.status.success());
    }
}

pub(crate) fn check_round_trips(name: &str, first: &str, second: &Option<String>) {
    if let Some(second) = second {
        if first != second {
            write_failure(name, first, second);
            panic!("Double round trip failed for {0}\ncheck ./test_failures/{0}.first.js and ./test_failures/{0}.second.js", name);
        } else {
            let mut env_write = false;
            for (key, val) in ::std::env::vars() {
                if key == "RESW_WRITE" && val == "1" {
                    env_write = true;
                    break;
                }
            }
            if env_write {
                write_failure(name, first, second);
            }
        }
    } else {
        ::std::fs::write(&format!("test_failures/{}.first.js", name), first)
            .expect("Failed to write file");
        panic!("Double round trip failed to parse second pass for {0}\n check ./test_failures/{0}.first.js", name);
    }
}
