#!/usr/bin/env python3

import os

IGNORE = [
    'e-feMorphology-012', # will timeout on CI
    'e-svg-007', # invalid encoding
    'e-svg-034', # invalid size
    'e-svg-035', # invalid size
    'e-svg-036', # invalid size

    'e-svg-009',
    'e-svg-010',
    'e-svg-011',
    'e-svg-015',
    'e-svg-017',
]

files = sorted(os.listdir('svg/'))
if '.directory' in files:
    files.remove('.directory')

print('// This file is auto-generated by gen-tests.py')
print()
print('#![allow(non_snake_case)]')
print()
print('mod render;')
print('use render::render;')
print()

for file in files:
    file = file.replace('.svg', '')
    fn_name = file.replace('-', '_')

    if file in IGNORE:
        continue

    print(f'#[test] fn {fn_name}() {{ assert_eq!(render("{file}"), 0); }}')
