use ress::prelude::*;
lazy_static! {
    pub static ref ES5: Vec<Token<&'static str>> =
        vec![
        Token::Comment(Comment::new_multi_line(
            " this file contains all grammatical productions in ECMA-262 edition 5.1 ** * *"
        )),
        Token::Comment(Comment::new_single_line(" whitespace")),
        Token::Ident("tab".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Ident("tab".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("verticalTab".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Ident("verticalTab".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("formFeed".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Ident("formFeed".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("space".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Ident("space".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("nbsp".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Ident("nbsp".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("bom".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Ident("bom".into()),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(" line terminators")),
        Token::Ident("lineFeed".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("carriageReturn".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("carriageReturnLineFeed".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("lineSeparator".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("paragraphSeparator".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(" identifier names")),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("$".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("_".into()),
        Token::Punct(Punct::Comma),
        Token::Ident(r"\u0078".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x$".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x_".into()),
        Token::Punct(Punct::Comma),
        Token::Ident(r"x\u0030".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("xa".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x0a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x0123456789".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("qwertyuiopasdfghjklzxcvbnm".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("QWERTYUIOPASDFGHJKLZXCVBNM".into()),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(
            " a representative sample of unicode letters and numbers"
        )),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("œ一".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ǻ둘".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ɤ〩".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("φ".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ﬁⅷ".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ユニコード".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x‌‍".into()),
        Token::Punct(Punct::SemiColon),
        Token::Null,
        Token::Punct(Punct::SemiColon),
        Token::Boolean(Boolean::True),
        Token::Punct(Punct::SemiColon),
        Token::Boolean(Boolean::False),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("00".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("1234567890".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("01234567".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.00".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("10.00".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number(".0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number(".00".into()),
        Token::Number("0e0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0E0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.e0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.00e+0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number(".00e-0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0x0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0X0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0x0123456789abcdefABCDEF".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("2e308".into()),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double("", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double("'", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r#"\'\"\\\b\f\n\r\t\v\0"#, false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r"\1\00\400\000", true)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r"\x01\x23\x45\x67\x89\xAB\xCD\xEF", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r"\u0123\u4567\u89AB\uCDEF", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(
            r"\
", false
        )),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single("", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single("\"", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r#"\'\"\\\b\f\n\r\t\v\0"#, false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r"\1\00\400\000", true)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r"\x01\x23\x45\x67\x89\xAB\xCD\xEF", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r"\u0123\u4567\u89AB\uCDEF", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(
            r"\
", false
        )),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("x", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("|", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("|||", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"^$\b\B", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("(?=(?!(?:(.))))", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"a.\f\n\r\t\v\0\[\-\/\\\x00\u0000", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"\d\D\s\S\w\W", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(
            r"\ca\cb\cc\cd\ce\cf\cg\ch\ci\cj\ck\cl\cm\cn\co\cp\cq\cr\cs\ct\cu\cv\cw\cx\cy\cz",
            None
        )),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(
            r"\cA\cB\cC\cD\cE\cF\cG\cH\cI\cJ\cK\cL\cM\cN\cO\cP\cQ\cR\cS\cT\cU\cV\cW\cX\cY\cZ",
            None
        )),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("[a-z-]", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"[^\b\-^]", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"[/\]\\]", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("i"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("g"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("m"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("igm"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".*", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".*?", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".+", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".+?", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".?", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".??", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".{0}", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".{0,}", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".{0,0}", None)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::This("this".into())),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("x", false)),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::String(StringLit::double("y", false)),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0.".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0.0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Number(".0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0e0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0x0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("get".into()),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::String(StringLit::single("y", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::String(StringLit::double("y", false)),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(
            " this function makes the NewExpression and CallExpression tests not throw at runtime"
        )),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("return".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Equal),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::Equal),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("new".into())),
        Token::Keyword(Keyword::New("new".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoublePlus),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoubleDash),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Delete("delete".into())),
        Token::Keyword(Keyword::Void("void".into())),
        Token::Keyword(Keyword::TypeOf("typeof".into())),
        Token::Punct(Punct::Plus),
        Token::Punct(Punct::Dash),
        Token::Punct(Punct::Tilde),
        Token::Punct(Punct::Bang),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::DoublePlus),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::DoubleDash),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Asterisk),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::ForwardSlash),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Percent),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Plus),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Dash),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleLessThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleGreaterThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::TripleGreaterThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::LessThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::GreaterThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::LessThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::GreaterThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Keyword(Keyword::InstanceOf("instanceof".into())),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::BangEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::TripleEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::BangDoubleEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Ampersand),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Caret),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Pipe),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleAmpersand),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoublePipe),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoublePipe),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::AsteriskEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::ForwardSlashEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::PercentEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::PlusEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DashEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoubleLessThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoubleGreaterThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::TripleGreaterThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::AmpersandEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::CaretEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::PipeEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("z".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::If("if".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::If("if".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Else("else".into())),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Do("do".into())),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::While("while".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::While("while".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("a".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("a".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("a".into()),
        Token::Punct(Punct::Equal),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("var".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::In("in".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Continue("continue".into())),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Continue("continue".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("for".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Break("break".into())),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("return".into())),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("return".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::With("with".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Default("default".into())),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Default("default".into())),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("case".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Default("default".into())),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("switch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Default("default".into())),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("y".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Try("try".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Throw("throw".into())),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("catch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Try("try".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("catch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Try("try".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Finally("finally".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Try("try".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("catch".into())),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Finally("finally".into())),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Debugger("debugger".into())),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::double("use strict", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("use strict", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::double("other directive", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("other directive", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::OpenParen),
        Token::String(StringLit::double("string", false)),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::OpenParen),
        Token::String(StringLit::single("string", false)),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("string", false)),
        Token::Punct(Punct::Plus),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Function("function".into())),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
    ];
}
