use ress::prelude::*;
lazy_static! {
    pub static ref TOKENS: Vec<Token<&'static str>> =
        vec![
        Token::Comment(Comment::new_multi_line(
            " this file contains all grammatical productions in ECMA-262 edition 5.1 ** * *"
        )),
        Token::Keyword(Keyword::Import("Import")),
        Token::Ident("i0".into()),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Import("Import")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("as".into()),
        Token::Ident("i1".into()),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Import("Import")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Import("Import")),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("i2".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("a".into()),
        Token::Ident("as".into()),
        Token::Ident("i3".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Import("Import")),
        Token::Ident("i4".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::Ident("as".into()),
        Token::Ident("i5".into()),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Import("Import")),
        Token::Ident("i6".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Import("Import")),
        Token::Ident("i7".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("i8".into()),
        Token::Punct(Punct::Comma),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("as".into()),
        Token::Ident("i9".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Import("Import")),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("i0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i1".into()),
        Token::Ident("as".into()),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i2".into()),
        Token::Ident("as".into()),
        Token::Keyword(Keyword::Var("Var")),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("from".into()),
        Token::String(StringLit::double("module", false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("i3".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i4".into()),
        Token::Ident("as".into()),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("e5".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("e6".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Let("Let")),
        Token::Ident("e7".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("e8".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Const("Const")),
        Token::Ident("e9".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("e10".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("e11".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("e12".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Class("Class")),
        Token::Ident("e13".into()),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Class("Class")),
        Token::Ident("e14".into()),
        Token::Keyword(Keyword::Extends("extends".into())),
        Token::Ident("e15".into()),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Export("Export")),
        Token::Keyword(Keyword::Default("Default")),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("e16".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Comment(Comment::new_single_line(
            " Unfortunately (for us), we can only have a single default export."
        )),
        Token::Comment(Comment::new_multi_line(
            "
export default function (){}
export default function* i16(){}
export default function* (){}
export default class i17 {}
export default class i18 extends i19 {}
export default class {}
export default x = 0;
export default 0;
export default (0, 1);
"
        )),
        Token::Comment(Comment::new_single_line(" whitespace")),
        Token::Ident("tab".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Ident("tab".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("verticalTab".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Ident("verticalTab".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("formFeed".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Ident("formFeed".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("space".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Ident("space".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("nbsp".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Ident("nbsp".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("bom".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Ident("bom".into()),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(" line terminators")),
        Token::Ident("lineFeed".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("carriageReturn".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("carriageReturnLineFeed".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("lineSeparator".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("paragraphSeparator".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(" identifier names")),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("$".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("_".into()),
        Token::Punct(Punct::Comma),
        Token::Ident(r"\u0078".into()),
        Token::Punct(Punct::Comma),
        Token::Ident(r"\u{2F9F9}".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x$".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x_".into()),
        Token::Punct(Punct::Comma),
        Token::Ident(r"x\u0030".into()),
        Token::Punct(Punct::Comma),
        Token::Ident(r"x\u{e01d5}".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("xa".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x0a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x0123456789".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("qwertyuiopasdfghjklzxcvbnm".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("QWERTYUIOPASDFGHJKLZXCVBNM".into()),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(
            " a representative sample of ID_Start and ID_Continue"
        )),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("䩶".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x󠇕".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("œ一".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ǻ둘".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ɤ〩".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("φ".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ﬁⅷ".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("ユニコード".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x‌‍".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Let("Let")),
        Token::Ident("letx".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Let("Let")),
        Token::Punct(Punct::OpenBracket),
        Token::Ident(r"x\u0078".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Const("Const")),
        Token::Ident("constx".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Let("Let")),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Let("Let")),
        Token::Ident("y".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Const("Const")),
        Token::Ident("z".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Null,
        Token::Punct(Punct::SemiColon),
        Token::Boolean(Boolean::True),
        Token::Punct(Punct::SemiColon),
        Token::Boolean(Boolean::False),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("1234567890".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.00".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("10.00".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number(".0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number(".00".into()),
        Token::Number("0e0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0E0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.e0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.00e+0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number(".00e-0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0x0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0X0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0x0123456789abcdefABCDEF".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0b0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0B0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0b01".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0b10".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0b10101010".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0o0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0O0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0o01234567".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("2e308".into()),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double("", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double("'", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r#"\'\"\\\b\f\n\r\t\v\0"#, false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r"\0", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r"\x01\x23\x45\x67\x89\xAB\xCD\xEF\xab\xcd\xef", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(r"\u0123\u4567\u89AB\uCDEF\u00ab\ucdef", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(
            r"\uD834\uDF06\u2603\u03C6 \u{0000001F4a9}\u{1D306}\u{2603}\u{3c6} 𝌆☃φ",
            false
        )),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::double(
            r"\
",
            false
        )),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single("", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single("\"", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r#"\'\"\\\b\f\n\r\t\v\0"#, false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r"\0", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r"\x01\x23\x45\x67\x89\xAB\xCD\xEF\xab\xcd\xef", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(r"\u0123\u4567\u89AB\uCDEF\u00ab\ucdef", false)),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(
            r"\uD834\uDF06\u2603\u03C6 \u{0000001F4a9} \u{1D306}\u{2603}\u{3c6} 𝌆☃φ",
            false,
        )),
        Token::Punct(Punct::SemiColon),
        Token::String(StringLit::single(
            r"\
", false,
        )),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("x", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("|", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("|||", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"^$\b\B", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("(?=(?!(?:(.))))", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"a.\f\n\r\t\v\0\[\-\/\\\x00\u0000\uD834\uDF06", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"\u{00000001d306}", Some("u"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"\d\D\s\S\w\W", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(
            r"\ca\cb\cc\cd\ce\cf\cg\ch\ci\cj\ck\cl\cm\cn\co\cp\cq\cr\cs\ct\cu\cv\cw\cx\cy\cz",
            None
        )),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(
            r"\cA\cB\cC\cD\cE\cF\cG\cH\cI\cJ\cK\cL\cM\cN\cO\cP\cQ\cR\cS\cT\cU\cV\cW\cX\cY\cZ",
            None
        )),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts("[a-z-]", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"[^\b\-^]", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(r"[/\]\\]", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("i"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("g"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("m"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".", Some("igm"))),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".*", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".*?", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".+", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".+?", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".?", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".??", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".{0}", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".{0,}", None)),
        Token::Punct(Punct::SemiColon),
        Token::RegEx(RegEx::from_parts(".{0,0}", None)),
        Token::Punct(Punct::SemiColon),
        Token::Template(Template::no_sub_template("a", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Template(Template::template_head("", false, false, false)),
        Token::Number("0".into()),
        Token::Template(Template::template_tail("", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Template(Template::template_head("0", false, false, false)),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("1".into()),
        Token::Template(Template::template_tail("2", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Template(Template::template_head("0", false, false, false)),
        Token::Template(Template::template_head("1", false, false, false)),
        Token::Number("2".into()),
        Token::Template(Template::template_tail("3", false, false, false)),
        Token::Template(Template::template_tail("4", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Template(Template::no_sub_template(r"\`", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Template(Template::no_sub_template(r"a\${b", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Template(Template::no_sub_template(r"\0\n\x0A\u000A\u{A}", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::This("This")),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("x", false)),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::String(StringLit::double("y", false)),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0.".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0.0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number(".0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0e0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0x0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::String(StringLit::single("y", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::String(StringLit::double("y", false)),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::Keyword(Keyword::Var("Var")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Keyword(Keyword::Var("Var")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Number("1".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::String(StringLit::single("b", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::String(StringLit::double("c", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Number(".1".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Number("1.".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Number("1e1".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Keyword(Keyword::Var("Var")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::Ident("d".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::String(StringLit::single("e", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::String(StringLit::double("f", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::Number("2".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::Number(".2".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::Number("3.".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::Number("2e2".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Asterisk),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("__proto__".into()),
        Token::Punct(Punct::Colon),
        Token::Null,
        Token::Punct(Punct::Comma),
        Token::Ident("get".into()),
        Token::Ident("__proto__".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Ident("set".into()),
        Token::Ident("__proto__".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::double("__proto__", false)),
        Token::Punct(Punct::Colon),
        Token::Null,
        Token::Punct(Punct::Comma),
        Token::Ident("__proto__".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0.".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Comment(Comment::new_single_line(
            " this function makes the NewExpression and CallExpression tests not throw at runtime"
        )),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("Return")),
        Token::Ident("f".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Equal),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::Equal),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::New("New")),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Period),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::Ellipsis),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("1".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("Return")),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Number("2".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Template(Template::no_sub_template("a", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Template(Template::template_head("0", false, false, false)),
        Token::Number("1".into()),
        Token::Template(Template::template_tail("2", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoublePlus),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoubleDash),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Delete("Delete")),
        Token::Keyword(Keyword::Void("Void")),
        Token::Keyword(Keyword::TypeOf("TypeOf")),
        Token::Punct(Punct::Plus),
        Token::Punct(Punct::Dash),
        Token::Punct(Punct::Tilde),
        Token::Punct(Punct::Bang),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::DoublePlus),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::DoubleDash),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Asterisk),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::ForwardSlash),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Percent),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Plus),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Dash),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleLessThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleGreaterThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::TripleGreaterThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::LessThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::GreaterThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::LessThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::GreaterThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Keyword(Keyword::InstanceOf("InstanceOf")),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::BangEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::TripleEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::BangDoubleEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Ampersand),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Caret),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Pipe),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoubleAmpersand),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoublePipe),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::DoublePipe),
        Token::Number("0".into()),
        Token::Punct(Punct::QuestionMark),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::AsteriskEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::ForwardSlashEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::PercentEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::PlusEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DashEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoubleLessThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::DoubleGreaterThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::TripleGreaterThanEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::AmpersandEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::CaretEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::PipeEqual),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x1".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y2".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x3".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y4".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("z5".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x6".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x7".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y8".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x9".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y10".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x11".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y12".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::If("If")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::If("If")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Else("Else")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Do("Do")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::While("While")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Do("Do")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::While("While")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Do("Do")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::While("While")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Number("0".into()),
        Token::Keyword(Keyword::While("While")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("a0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("a1".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b2".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("a3".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("a4".into()),
        Token::Punct(Punct::Equal),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x12".into()),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Ident("of".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Var("Var")),
        Token::Ident("x13".into()),
        Token::Ident("of".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Continue("Continue")),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Continue("Continue")),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Break("Break")),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Break("Break")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("Return")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f1".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("Return")),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Default("Default")),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Default("Default")),
        Token::Punct(Punct::Colon),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Case("Case")),
        Token::Number("0".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Default("Default")),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Switch("Switch")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Default("Default")),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Ident("x".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("y".into()),
        Token::Punct(Punct::Colon),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Try("Try")),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Throw("Throw")),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("Catch")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Try("Try")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("Catch")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Try("Try")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Finally("Finally")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Try("Try")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("Catch")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Finally("Finally")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Debugger("Debugger")),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f2".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f3".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f4".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f5".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f6".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f7".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::For("For")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::Plus),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f8".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Number("0".into()),
        Token::Keyword(Keyword::Do("Do")),
        Token::Punct(Punct::Plus),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f9".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::While("While")),
        Token::Punct(Punct::OpenParen),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f10".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f11".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::double("use strict", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f12".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("use strict", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f13".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::double("other directive", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f14".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("other directive", false)),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f15".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::OpenParen),
        Token::String(StringLit::double("string", false)),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f16".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::OpenParen),
        Token::String(StringLit::single("string", false)),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f17".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::single("string", false)),
        Token::Punct(Punct::Plus),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("g0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("Return")),
        Token::Ident("a".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Ident("c".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("g1".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("Return")),
        Token::Ident("a".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Ident("c".into()),
        Token::Punct(Punct::Equal),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("y".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Function("Function")),
        Token::Ident("f".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Number("0".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Ident("x".into()),
        Token::Ident("x".into()),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Ident("x".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Ident("x".into()),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Ident("y".into()),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Ident("x".into()),
        Token::Ident("x".into()),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Ident("x".into()),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Return("Return")),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("x".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Equal),
        Token::Punct(Punct::OpenBracket),
        Token::Punct(Punct::Ellipsis),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Equal),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Try("Try")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("Catch")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Try("Try")),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Catch("Catch")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Class("Class")),
        Token::Ident("A".into()),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Class("Class")),
        Token::Ident("B".into()),
        Token::Keyword(Keyword::Extends("extends".into())),
        Token::Keyword(Keyword::New("New")),
        Token::Ident("A".into()),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("constructor".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Super("Super")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::New("New")),
        Token::Punct(Punct::Period),
        Token::Ident("target".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Super("Super")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Template(Template::no_sub_template("template", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Keyword(Keyword::Super("Super")),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::This("This")),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("m".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("b".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBracket),
        Token::Ident("c".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Comma),
        Token::Ident("d".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("e".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::OpenBrace),
        Token::Ident("f".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("g".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("h".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::Comma),
        Token::Ident("i".into()),
        Token::Punct(Punct::Colon),
        Token::Ident("j".into()),
        Token::Punct(Punct::Equal),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Comma),
        Token::Punct(Punct::Ellipsis),
        Token::Ident("k".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Super("Super")),
        Token::Punct(Punct::Period),
        Token::Ident("m".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Super("Super")),
        Token::Punct(Punct::Period),
        Token::Ident("m".into()),
        Token::Template(Template::no_sub_template("template", false, false, false)),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::EqualGreaterThan),
        Token::Keyword(Keyword::Super("Super")),
        Token::Punct(Punct::Period),
        Token::Ident("m".into()),
        Token::Punct(Punct::OpenParen),
        Token::Keyword(Keyword::This("This")),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::SemiColon),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::String(StringLit::single("b", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Punct(Punct::Asterisk),
        Token::Ident("c".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Punct(Punct::Asterisk),
        Token::String(StringLit::double("d", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Punct(Punct::Asterisk),
        Token::Number("1".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Punct(Punct::Asterisk),
        Token::Punct(Punct::OpenBracket),
        Token::Number("1".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Keyword(Keyword::Var("Var")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Punct(Punct::Asterisk),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("get".into()),
        Token::Ident("e".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("get".into()),
        Token::String(StringLit::single("f", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("get".into()),
        Token::Number("2".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("get".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("2".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("set".into()),
        Token::Ident("g".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("set".into()),
        Token::String(StringLit::double("h", false)),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("set".into()),
        Token::Number("3".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("set".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("3".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("get".into()),
        Token::Keyword(Keyword::If("If")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Static("Static")),
        Token::Ident("set".into()),
        Token::Keyword(Keyword::If("If")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("a".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::String(StringLit::single("b", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Number("0".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::OpenBracket),
        Token::Number("0".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Asterisk),
        Token::Ident("c".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Asterisk),
        Token::String(StringLit::double("d", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Asterisk),
        Token::Number("1".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Asterisk),
        Token::Punct(Punct::OpenBracket),
        Token::Number("1".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Var("Var")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::Asterisk),
        Token::Keyword(Keyword::In("In")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Yield("Yield")),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("get".into()),
        Token::Ident("e".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("get".into()),
        Token::String(StringLit::single("f", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("get".into()),
        Token::Number("2".into()),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("get".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("2".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("set".into()),
        Token::Ident("g".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("set".into()),
        Token::String(StringLit::double("h", false)),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("set".into()),
        Token::Number("3".into()),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("set".into()),
        Token::Punct(Punct::OpenBracket),
        Token::Number("3".into()),
        Token::Punct(Punct::CloseBracket),
        Token::Punct(Punct::OpenParen),
        Token::Ident("a".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("get".into()),
        Token::Keyword(Keyword::If("If")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Ident("set".into()),
        Token::Keyword(Keyword::If("If")),
        Token::Punct(Punct::OpenParen),
        Token::Ident("f".into()),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
        Token::Keyword(Keyword::Class("Class")),
        Token::Ident("C".into()),
        Token::Keyword(Keyword::Extends("extends".into())),
        Token::Ident("B".into()),
        Token::Punct(Punct::OpenBrace),
        Token::String(StringLit::double("constructor", false)),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::OpenBrace),
        Token::Keyword(Keyword::Super("Super")),
        Token::Punct(Punct::OpenParen),
        Token::Punct(Punct::CloseParen),
        Token::Punct(Punct::SemiColon),
        Token::Punct(Punct::CloseBrace),
        Token::Punct(Punct::CloseBrace),
    ];
}
