use res_regex::RegexParser;
#[test]
fn moz_central() {
    let _ = pretty_env_logger::try_init();
    for (i, regex) in REGEXES.iter().enumerate() {
        let mut parser = RegexParser::new(regex).expect("unable to contruct the parser");
        parser
            .validate()
            .expect(&format!("{}: failed to parse {}", i, regex));
    }
}
static REGEXES: &[&str] = &[
    r#"/agggtaaa|tttaccct/ig"#,
    r#"/[cgt]gggtaaa|tttaccc[acg]/ig"#,
    r#"/a[act]ggtaaa|tttacc[agt]t/ig"#,
    r#"/ag[act]gtaaa|tttac[agt]ct/ig"#,
    r#"/agg[act]taaa|ttta[agt]cct/ig"#,
    r#"/aggg[acg]aaa|ttt[cgt]ccct/ig"#,
    r#"/agggt[cgt]aa|tt[acg]accct/ig"#,
    r#"/agggta[cgt]a|t[acg]taccct/ig"#,
    r#"/agggtaa[cgt]|[acg]ttaccct/ig"#,
    r#"/>.*\n|\n/g"#,
    r#"/^[\],:{}\s]*$/"#,
    r#"/\\./g"#,
    r#"/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(:?[eE][+\-]?\d+)?/g"#,
    r#"/(?:^|:|,)(?:\s*\[)+/g"#,
    r#"/["\\\x00-\x1f]/"#,
    r#"/[\x00-\x1f\\"]/g"#,
    r#"/([0-9.]+)px/g"#,
    r#"/[\0\t\n\v\f\r\xa0'"!-]/g"#,
    r#"/!\d\d?\d?!/g"#,
    r#"/[\u0080-\u07ff]/g"#,
    r#"/[\u0800-\uffff]/g"#,
    r#"/[\u00c0-\u00df][\u0080-\u00bf]/g"#,
    r#"/[\u00e0-\u00ef][\u0080-\u00bf][\u0080-\u00bf]/g"#,
    r#"/^.*? ([A-Z]{3}) [0-9]{4}.*$/"#,
    r#"/^.*?\(([A-Z])[a-z]+ ([A-Z])[a-z]+ ([A-Z])[a-z]+\)$/"#,
    r#"/('|\\)/g"#,
    r#"/^2017-09-05Tuesday, September 05, 2017 [0-9:]* AM$/"#,
    r#"/^/"#,
    r#"/can't convert the number/"#,
    r#"/attempting to convert an empty CDataFinalizer at argument 1 of ctypes\.FunctionType\(ctypes\.default_abi, ctypes\.int32_t, \[ctypes\.int32_t\]\)\.ptr\(ctypes\.UInt64\(\"[x0-9A-Fa-f]+\"\)\)/"#,
    r#"/can't pass the string "foo" to argument 1 of ctypes\.FunctionType\(ctypes\.default_abi, ctypes\.voidptr_t, \[ctypes\.int32_t\]\)\.ptr\(ctypes\.UInt64\("[x0-9A-Fa-f]+"\)\)/"#,
    r#"/can't convert the string \"foo\" to the 'x' field \(int32_t\) of test_struct at argument 1 of ctypes\.FunctionType\(ctypes\.default_abi, ctypes.int32_t, \[test_struct\]\)\.ptr\(ctypes\.UInt64\(\"[x0-9A-Fa-f]+\"\)\)/"#,
    r#"/property count of the object \(\{x:\"foo\", y:\"bar\"\}\) does not match to field count of the type test_struct \(expected 1, got 2\) at argument 1 of ctypes\.FunctionType\(ctypes\.default_abi, ctypes\.int32_t, \[test_struct\]\)\.ptr\(ctypes\.UInt64\(\"[x0-9A-Fa-f]+\"\)\)/"#,
    r#"/property name the number 0 of the object \(\{0:\"foo\"\}\) is not a string at argument 1 of ctypes\.FunctionType\(ctypes\.default_abi, ctypes\.int32_t, \[test_struct\]\)\.ptr\(ctypes\.UInt64\(\"[x0-9A-Fa-f]+\"\)\)/"#,
    r#"/base type ctypes\.int32_t\.ptr\(ctypes\.UInt64\(\"[x0-9A-Fa-f]+\"\)\) is not an 8-bit or 16-bit integer or character type/"#,
    r#"/^1+0+$/"#,
    r#"/^1+$/"#,
    r#"/^1+0+1$/"#,
    r#"/I/"#,
    r#"/(.*)$/"#,
    r#"/./"#,
    r#"/x/"#,
    r#"/^\w is not a function$/"#,
    r#"/^ba/"#,
    r#"/(((\w+):\/\/)([^\/:]*)(:(\d+))?)?([^#?]*)(\?([^#]*))?(#(.*))?/"#,
    r#"/^\s*|\s*$/g"#,
    r#"/\bQBZPbageby_cynprubyqre\b/"#,
    r#"/,/"#,
    r#"/\bQBZPbageby_cynprubyqre\b/g"#,
    r#"/^[\s\xa0]+|[\s\xa0]+$/g"#,
    r#"/(\d*)(\D*)/g"#,
    r#"/=/"#,
    r#"/(^|\s)lhv\-h(\s|$)/"#,
    r#"/\#/g"#,
    r#"/\./g"#,
    r#"/'/g"#,
    r#"/\?[\w\W]*(sevraqvq|punaaryvq|tebhcvq)=([^\&\?#]*)/i"#,
    r#"/\s+/g"#,
    r#"/^\s*(\S*(\s+\S+)*)\s*$/"#,
    r#"/(-[a-z])/i"#,
    r#"/qqqq|qqq|qq|q|ZZZZ|ZZZ|ZZ|Z|llll|ll|l|uu|u|UU|U|zz|z|ff|f|gg|g|sss|ss|s|mmm|mm|m/g"#,
    r#"/JroXvg\/(\S+)/"#,
    r#"/\[/g"#,
    r#"/(?:^|;)\s*sevraqfgre_ynat=([^;]*)/"#,
    r#"/([a-zA-Z]|\s)+/"#,
    r#"/(^|[^\\])\"\\\/Qngr\((-?[0-9]+)\)\\\/\"/g"#,
    r#"/^\s+|\s+$/g"#,
    r#"/(?:^|\s+)ba(?:\s+|$)/"#,
    r#"/[+, ]/"#,
    r#"/ybnqrq|pbzcyrgr/"#,
    r#"/(\s)+e/"#,
    r#"/Fnsnev\/(\d+\.\d+)/"#,
    r#"/d1/g"#,
    r#"/NQ_VQ/g"#,
    r#"/d2/g"#,
    r#"/_/g"#,
    r#"/(?:ZFVR.(\d+\.\d+))|(?:(?:Sversbk|TenaCnenqvfb|Vprjrnfry).(\d+\.\d+))|(?:Bcren.(\d+\.\d+))|(?:NccyrJroXvg.(\d+(?:\.\d+)?))/"#,
    r#"/(Znp BF K)|(Jvaqbjf;)/"#,
    r#"/Trpxb\/([0-9]+)/"#,
    r#"/\bso_zrah\b/"#,
    r#"/^(?:(?:[^:\/?#]+):)?(?:\/\/(?:[^\/?#]*))?([^?#]*)(?:\?([^#]*))?(?:#(.*))?/"#,
    r#"/uggcf?:\/\/([^\/]+\.)?snprobbx\.pbz\//"#,
    r#"/"/g"#,
    r#"/^([^?#]+)(?:\?([^#]*))?(#.*)?/"#,
    r#"/\buvqqra_ryrz\b/g"#,
    r#"/\buvqqra_ryrz\b/"#,
    r#"/puebzr/i"#,
    r#"/(?:^|\s+)gvzrfgnzc(?:\s+|$)/"#,
    r#"/-\D/g"#,
    r#"/\bnpgvingr\b/"#,
    r#"/%2R/gi"#,
    r#"/%2S/gi"#,
    r#"/^(mu-(PA|GJ)|wn|xb)$/"#,
    r#"/\s?;\s?/"#,
    r#"/%\w?$/"#,
    r#"/TNQP=([^;]*)/i"#,
    r#"/[<>]/g"#,
    r#"/[A-Za-z]/g"#,
    r#"/zfvr/gi"#,
    r#"/bcren/gi"#,
    r#"/%3P/g"#,
    r#"/%3R/g"#,
    r#"/%3q/g"#,
    r#"/uers|fep|fryrpgrq/"#,
    r#"/\s*([+>~\s])\s*([a-zA-Z#.*:\[])/g"#,
    r#"/^(\w+|\*)$/"#,
    r#"/\\/g"#,
    r#"/ /g"#,
    r#"/\/\xc4\/t/"#,
    r#"/\/\xd6\/t/"#,
    r#"/\/\xdc\/t/"#,
    r#"/\/\xdf\/t/"#,
    r#"/\/\xe4\/t/"#,
    r#"/\/\xf6\/t/"#,
    r#"/\/\xfc\/t/"#,
    r#"/\W/g"#,
    r#"/uers|fep|fglyr/"#,
    r#"/\*/g"#,
    r#"/\bnpgvir\b/"#,
    r#"/sversbk/i"#,
    r#"/zfvr/i"#,
    r#"/bcren/i"#,
    r#"/\.([\w-]+)|\[(\w+)(?:([!*^$~|]?=)["']?(.*?)["']?)?\]|:([\w-]+)(?:\(["']?(.*?)?["']?\)|$)/g"#,
    r#"/(\s+e|\s+o[0-9]+)/"#,
    r#"/</g"#,
    r#"/>/g"#,
    r#"/(?:^|\s+)fryrpgrq(?:\s+|$)/"#,
    r#"/\&/g"#,
    r#"/\+/g"#,
    r#"/\?/g"#,
    r#"/\t/g"#,
    r#"/(\$\{nqiHey\})|(\$nqiHey\b)/g"#,
    r#"/(\$\{cngu\})|(\$cngu\b)/g"#,
    r#"/NccyrJroXvg\/([^\s]*)/"#,
    r#"/XUGZY/"#,
    r#"/(\$\{cebg\})|(\$cebg\b)/g"#,
    r#"/^(.*)\..*$/"#,
    r#"/^.*e(.*)$/"#,
    r#"/^.*\s+(\S+\s+\S+$)/"#,
    r#"/(\$\{ubfg\})|(\$ubfg\b)/g"#,
    r#"/(\$\{dz\})|(\$dz\b)/g"#,
    r#"/e/"#,
    r#"/##yv4##/gi"#,
    r#"/##yv16##/gi"#,
    r#"/##yv19##/gi"#,
    r#"/(?:^|\s+)bss(?:\s+|$)/"#,
    r#"/^(([^:\/?#]+):)?(\/\/([^\/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?$/"#,
    r#"/^[^<]*(<(.|\s)+>)[^>]*$|^#(\w+)$/"#,
    r#"/##yv0##/gi"#,
    r#"/##\/o##/gi"#,
    r#"/##\/v##/gi"#,
    r#"/##\/h##/gi"#,
    r#"/##o##/gi"#,
    r#"/##oe##/gi"#,
    r#"/##v##/gi"#,
    r#"/##h##/gi"#,
    r#"/##n##/gi"#,
    r#"/##\/n##/gi"#,
    r#"/#~#argjbexybtb#~#/g"#,
    r#"/ Zbovyr\//"#,
    r#"/##yv1##/gi"#,
    r#"/##yv10##/gi"#,
    r#"/##yv11##/gi"#,
    r#"/##yv12##/gi"#,
    r#"/##yv13##/gi"#,
    r#"/##yv14##/gi"#,
    r#"/##yv15##/gi"#,
    r#"/##yv17##/gi"#,
    r#"/##yv18##/gi"#,
    r#"/##yv2##/gi"#,
    r#"/##yv20##/gi"#,
    r#"/##yv21##/gi"#,
    r#"/##yv22##/gi"#,
    r#"/##yv23##/gi"#,
    r#"/##yv3##/gi"#,
    r#"/##yv5##/gi"#,
    r#"/##yv6##/gi"#,
    r#"/##yv7##/gi"#,
    r#"/##yv8##/gi"#,
    r#"/##yv9##/gi"#,
    r#"/AbxvnA[^\/]*/"#,
    r#"/(?:^|\s+)bss(?:\s+|$)/g"#,
    r#"/(\$\{0\})|(\$0\b)/g"#,
    r#"/(\$\{1\})|(\$1\b)/g"#,
    r#"/(\$\{pbzcyrgr\})|(\$pbzcyrgr\b)/g"#,
    r#"/(\$\{sentzrag\})|(\$sentzrag\b)/g"#,
    r#"/(\$\{ubfgcbeg\})|(\$ubfgcbeg\b)/g"#,
    r#"/(\$\{cebgbpby\})|(\$cebgbpby\b)/g"#,
    r#"/(\$\{dhrel\})|(\$dhrel\b)/g"#,
    r#"/(\$\{2\})|(\$2\b)/g"#,
    r#"/(\$\{3\})|(\$3\b)/g"#,
    r#"/ PC=i=(\d+)&oe=(.)/"#,
    r#"/Fnsnev|Xbadhrebe|XUGZY/gi"#,
    r#"/\{0\}/g"#,
    r#"/(^|.)(ronl|qri-ehf3.wbg)(|fgberf|zbgbef|yvirnhpgvbaf|jvxv|rkcerff|punggre).(pbz(|.nh|.pa|.ux|.zl|.ft|.oe|.zk)|pb(.hx|.xe|.am)|pn|qr|se|vg|ay|or|ng|pu|vr|va|rf|cy|cu|fr)$/i"#,
    r#"/\b[a-z]/g"#,
    r#"/^uggc:\/\//"#,
    r#"/(?:^|\s+)qvfnoyrq(?:\s+|$)/"#,
    r#"/\d+/g"#,
    r#"/[A-Z]/g"#,
    r#"/#([\w-]+)/"#,
    r#"/NqborNVE\/([^\s]*)/"#,
    r#"/NccyrJroXvg\/([^ ]*)/"#,
    r#"/XUGZY/gi"#,
    r#"/^(?:obql|ugzy)$/i"#,
    r#"/^(\w+|\*)/"#,
    r#"/znp|jva|yvahk/i"#,
    r#"/eton?\([\d\s,]+\)/"#,
    r#"/\r/g"#,
    r#"/((ZFVR\s+([6-9]|\d\d)\.))/"#,
    r#"/Xbadhrebe|Fnsnev|XUGZY/"#,
    r#"/zrah_byq/g"#,
    r#"/^([#.]?)((?:[\w\u0128-\uffff*_-]|\\.)*)/"#,
    r#"/\{1\}/g"#,
    r#"/\s+/"#,
    r#"/(\$\{4\})|(\$4\b)/g"#,
    r#"/(\$\{5\})|(\$5\b)/g"#,
    r#"/\{2\}/g"#,
    r#"/[^+>] [^+>]/"#,
    r#"/\bucpyv\s*=\s*([^;]*)/i"#,
    r#"/\bucuvqr\s*=\s*([^;]*)/i"#,
    r#"/\bucfie\s*=\s*([^;]*)/i"#,
    r#"/\bhfucjrn\s*=\s*([^;]*)/i"#,
    r#"/\bmvc\s*=\s*([^;]*)/i"#,
    r#"/^((?:[\w\u0128-\uffff*_-]|\\.)+)(#)((?:[\w\u0128-\uffff*_-]|\\.)+)/"#,
    r#"/^([>+~])\s*(\w*)/i"#,
    r#"/^>\s*((?:[\w\u0128-\uffff*_-]|\\.)+)/"#,
    r#"/^[\s[]?shapgvba/"#,
    r#"/v\/g.tvs#(.*)/i"#,
    r#"/&/g"#,
    r#"/(\$\{anzr\})|(\$anzr\b)/g"#,
    r#"/(..-HF)(\|(\d+)|)/i"#,
    r#"/ZFVR\s+5[.]01/"#,
    r#"/HF(?=;)/i"#,
    r#"/\bp:(..)/i"#,
    r#"/\bhfucce\s*=\s*([^;]*)/i"#,
    r#"/\bjci\s*=\s*([^;]*)/i"#,
    r#"/\|p:([a-z]{2})/i"#,
    r#"/^Fubpxjnir Synfu (\d)/"#,
    r#"/^Fubpxjnir Synfu (\d+)/"#,
    r#"/jroxvg/"#,
    r#"/eaq_zbqobkva/"#,
    r#"/^erzbgr_vsenzr_/"#,
    r#"/\-/g"#,
    r#"/^$/"#,
    r#"/^znk\d+$/"#,
    r#"/^zva\d+$/"#,
    r#"/^erfgber$/"#,
    r#"/frpgvba\d+_pbagragf/"#,
    r#"/;\s*/"#,
    r#"/(\$\{inyhr\})|(\$inyhr\b)/g"#,
    r#"/(\$\{abj\})|(\$abj\b)/g"#,
    r#"/\s+$/"#,
    r#"/^\s+/"#,
    r#"/(\\\"|\x00-|\x1f|\x7f-|\x9f|\u00ad|\u0600-|\u0604|\u070f|\u17b4|\u17b5|\u200c-|\u200f|\u2028-|\u202f|\u2060-|\u206f|\ufeff|\ufff0-|\uffff)/g"#,
    r#"/^(:)([\w-]+)\("?'?(.*?(\(.*?\))?[^(]*?)"?'?\)/"#,
    r#"/^([:.#]*)((?:[\w\u0128-\uffff*_-]|\\.)+)/"#,
    r#"/^(\[) *@?([\w-]+) *([!*$^~=]*) *('?"?)(.*?)\4 *\]/"#,
    r#"/^.*\.(.*)\s.*$/"#,
    r#"/^.*jroxvg\/(\d+(\.\d+)?).*$/"#,
    r#"/\b\w+\b/g"#,
    r#"/\//g"#,
    r#"/#[a-z0-9]+$/i"#,
    r#"/(?:^|\s+)lhv-ani(?:\s+|$)/"#,
    r#"/(?:^|\s+)lhv-anifrg(?:\s+|$)/"#,
    r#"/(?:^|\s+)lhv-anifrg-gbc(?:\s+|$)/"#,
    r#"/(pbzcngvoyr|jroxvg)/"#,
    r#"/.+(?:ei|vg|en|vr)[\/: ]([\d.]+)/"#,
    r#"/\/onfr.wf(\?.+)?$/"#,
    r#"/xbadhrebe/"#,
    r#"/znp/"#,
    r#"/zbmvyyn/"#,
    r#"/zfvr/"#,
    r#"/ag\s5\.1/"#,
    r#"/bcren/"#,
    r#"/fnsnev/"#,
    r#"/jva/"#,
    r#"/jvaqbjf/"#,
    r#"/^[a-z\s]*/i"#,
    r#"/tracejit/"#,
    r#"/a/"#,
    r#"/s/"#,
    r#"/@/"#,
    r#"/abc/"#,
    r#"/jsreftest.html/"#,
    r#"/\\n/g"#,
    r#"/[^\x20-\x7E]+/g"#,
    r#"/\s/"#,
    r#"/abcdef/g"#,
    r#"/abcdefg/g"#,
    r#"/a\.*b[cC]+/g"#,
    r#"/bar\d\d/"#,
    r#"/bar\d\d/g"#,
    r#"/bar(\d\d)/g"#,
    r#"/abcd[eE]/g"#,
    r#"/b[aA]r/"#,
    r#"/abcdefghijklm[0-5]/"#,
    r#"/bar\u0178\d/i"#,
    r#"/bar/"#,
    r#"/hi/"#,
    r#"/invalid conversion to integer/"#,
    r#"/integer overflow/"#,
    r#"/parsing/"#,
    r#"/type mismatch/"#,
    r#"/failed to read end/"#,
    r#"/out of range/"#,
    r#"/can't write an immutable global/"#,
    r#"/not a number/"#,
    r#"/not a Number/"#,
    r#"/must reference a global immutable import/"#,
    r#"/import object field 'x' is not a Number/"#,
    r#"/cannot pass i64 to or from JS/"#,
    r#"/can't set value of immutable global/"#,
    r#"/bad type for a WebAssembly.Global/"#,
    r#"/Global requires at least 1 argument/"#,
    r#"/imported global mutability mismatch/"#,
    r#"/shared memory is disabled/"#,
    r#"/^function\s*[a-zA-Z$_0-9]*\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/"#,
    r#"/__Z[\w\d_]+/g"#,
    r#"/\.(jpg|jpeg|png|bmp)$/i"#,
    r#"/popping value from empty stack/"#,
    r#"/wasm text error/"#,
    r#"/label.*not found/"#,
    r#"/unknown start function/"#,
    r#"/must be nullary/"#,
    r#"/must not return anything/"#,
    r#"/second argument must be an object/"#,
    r#"/cmpxchg/"#,
    r#"/bad Memory maximum size/"#,
    r#"/bad Memory initial size/"#,
    r#"/bad Table maximum size/"#,
    r#"/bad Table initial size/"#,
    r#"/import object field 'foo' is not an Object/"#,
    r#"/import object field 'bar' is not a Function/"#,
    r#"/import object field 'baz' is not an Object/"#,
    r#"/import object field 'quux' is not a Function/"#,
    r#"/import object field 'x' is not an Object/"#,
    r#"/import object field 'y' is not a Memory/"#,
    r#"/imported Memory with incompatible size/"#,
    r#"/imported Memory with incompatible maximum size/"#,
    r#"/import object field 'bar' is not a Memory/"#,
    r#"/imported Table with incompatible size/"#,
    r#"/imported Table with incompatible maximum size/"#,
    r#"/maximum length 1 is less than initial length 2/"#,
    r#"/imported function 'a.b' signature mismatch/"#,
    r#"/imported function 'c.d' signature mismatch/"#,
    r#"/bad Table get index/"#,
    r#"/exported function index out of bounds/"#,
    r#"/exported global index out of bounds/"#,
    r#"/exported memory index out of bounds/"#,
    r#"/exported table index out of bounds/"#,
    r#"/already have default memory/"#,
    r#"/data segment does not fit/"#,
    r#"/elem segment does not fit/"#,
    r#"/failed to grow memory/"#,
    r#"/index out of bounds/"#,
    r#"/indirect call to null/"#,
    r#"/failed to grow table/"#,
    r#"/unused values not explicitly dropped by end of block/"#,
    r#"/br_table targets must all have the same arity/"#,
    r#"/proxy handler's get trap/"#,
    r#"/out of memory/"#,
    r#"/undefined/"#,
    r#"/unreachable/"#,
    r#"/unreachable executed/"#,
    r#"/is undefined/"#,
    r#"/caller/"#,
    r#"/failed to match magic number/"#,
    r#"/expected custom section/"#,
    r#"/too many types/"#,
    r#"/expected type form/"#,
    r#"/too many arguments in signature/"#,
    r#"/bad type/"#,
    r#"/signature index out of range/"#,
    r#"/expected code section/"#,
    r#"/byte size mismatch in code section/"#,
    r#"/data segment requires a memory section/"#,
    r#"/table element out of range/"#,
    r#"/number of memories must be at most one/"#,
    r#"/function body length mismatch/"#,
    r#"/validated with warning.*'name' custom section/"#,
    r#"/invalid .*block type/"#,
    r#"/unrecognized opcode/"#,
    r#"/unable to read opcode/"#,
    r#"/if without else with a result value/"#,
    r#"/branch depth exceeds current nesting level/"#,
    r#"/can't touch memory/"#,
    r#"/invalid data initializer-kind/"#,
    r#"/memory index must be zero/"#,
    r#"/data segment with memory index must have offset/"#,
    r#"/can't handle non-default memory/"#,
    r#"/'shared' is true but maximum is not specified/"#,
    r#"/maximum length required for shared memory/"#,
    r#"/unshared memory but shared required/"#,
    r#"/shared memory but unshared required/"#,
    r#"/unaligned memory access/"#,
    r#"/^wasm-function\[(\d*)\]$/"#,
    r#"/^0x([0-9a-f]*)$/"#,
    r#"/^(.*)@(.*):(.*):(.*)$/"#,
    r#"/integer divide by zero/"#,
    r#"/indirect call signature mismatch/"#,
    r#"/too much recursion/"#,
    r#"/at offset (\d*)/"#,
    r#"/data.drop segment index out of range/"#,
    r#"/active data segment requires a memory section/"#,
    r#"/can't touch memory without memory/"#,
    r#"/memory.init segment index out of range/"#,
    r#"/use of dropped data segment/"#,
    r#"/parsing wasm text at/"#,
    r#"/element segment index out of range for elem.drop/"#,
    r#"/active elem segment requires a table/"#,
    r#"/table index out of range/"#,
    r#"/table.init segment index out of range/"#,
    r#"/use of dropped element segment/"#,
    r#"/parsing wasm text/"#,
    r#"/> WebAssembly.Module":wasm-function\[1\]:0x/"#,
    r#"/can only pass WebAssembly exported functions to funcref/"#,
    r#"/\(ref T\) types not enabled|bad type/"#,
    r#"/can't convert undefined/"#,
    r#"/unrecognized opcode|(Structure|reference) types not enabled|invalid inline block type|bad type/"#,
    r#"/ref/"#,
    r#"/expression has type anyref but expected funcref/"#,
    r#"/segment's element type must be subtype of table's element type/"#,
    r#"/imported table type mismatch/"#,
    r#"/indirect calls must go through a table of 'funcref'/"#,
    r#"/table index out of range for table.get/"#,
    r#"/type mismatch: expression has type anyref but expected funcref/"#,
    r#"/table index out of range for table.set/"#,
    r#"/bad [Tt]able grow delta/"#,
    r#"/table index out of range for table.grow/"#,
    r#"/cannot expose reference type/"#,
    r#"/table index out of bounds/"#,
    r#"/type mismatch: expression has type f64 but expected i32/"#,
    r#"/type mismatch: expression has type f32 but expected anyref/"#,
    r#"/type mismatch: expression has type i64 but expected i32/"#,
    r#"/field is not mutable/"#,
    r#"/expression has type f32 but expected i32/"#,
    r#"/field index out of range/"#,
    r#"/expression has type.*but expected.*/"#,
    r#"/invalid narrowing operation/"#,
    r#"/struct.narrow requires ref type/"#,
    r#"/invalid reference type for struct.narrow/"#,
    r#"/invalid type combination in struct.narrow/"#,
    r#"/dereferencing null pointer/"#,
    r#"/setting immutable field/"#,
    r#"/not constructible/"#,
    r#"/imported global type mismatch/"#,
    r#"/import object field 'i32' is not a Number/"#,
    r#"/immutable global/"#,
    r#"/function index out of range/"#,
    r#"/function index is not in an element segment/"#,
    r#"/segments with element expressions can only contain references/"#,
    r#"/declared segment's element type must be subtype of funcref/"#,
    r#"/declared element segments cannot contain ref.null/"#,
    r#"/duplicate field name/"#,
    r#"/unused values/"#,
    r#"/not a struct type/"#,
    r#"/duplicate type name/"#,
    r#"/bad type definition/"#,
    r#"/signature index references non-signature/"#,
    r#"/table index out of range for table.copy/"#,
    r#"/table index out of range for table.size/"#,
    r#"/table index out of range for table.init/"#,
    r#"/table index out of range for element segment/"#,
    r#"/table index out of range for call_indirect/"#,
    r#"/expected element segment reference/"#,
    r#"/source is required if target is specified/"#,
    r#"/GC feature version.*no longer supported by this engine/"#,
    r#"/GC feature version is unknown/"#,
    r#"/"element" property of table descriptor must be "funcref"/"#,
    r#"/Type label.*not found/"#,
    r#"/expression has type ref.*but expected ref/"#,
    r#"/does not reference a struct type/"#,
    r#"/expression has type anyref but expected ref/"#,
    r#"/Structure types not enabled/"#,
    r#"/duplicate export/"#,
    r#"/i64/"#,
    r#"/import object field '\w*' is not an Object/"#,
    r#"/import object field '\w*' is not a Function/"#,
    r#"/initial memory size too big/"#,
    r#"/maximum memory size too big/"#,
    r#"/local.get index out of range/"#,
    r#"/local.set index out of range/"#,
    r#"/callee index out of range/"#,
    r#"/can't call_indirect without a table/"#,
    r#"/select operand types must match/"#,
    r#"/requires at least 1 argument/"#,
    r#"/first argument must be an ArrayBuffer or typed array object/"#,
    r#"/elem segment requires a table/"#,
    r#"/invalid elem segment flags field/"#,
    r#"/number of data segments does not match declared count/"#,
    r#"/memory.init requires a DataCount section/"#,
    r#"/data.drop requires a DataCount section/"#,
    r#"/failed to read initializer operation/"#,
    r#"/failed to read end of initializer expression/"#,
    r#"/Function label '\$b' not found/"#,
    r#"/duplicate import/"#,
    r#"/duplicate function/"#,
    r#"/duplicate var/"#,
    r#"/Local label '\$a' not found/"#,
    r#"/duplicate signature/"#,
    r#"/Function label '\$abc' not found/"#,
    r#"/Signature label '\$b' not found/"#,
    r#"/Signature label '\$c' not found/"#,
    r#"/branch target label '\$a' not found/"#,
    r#"/import after function definition/"#,
    r#"/import after global definition/"#,
    r#"/unsupported type for structured data/"#,
    r#"/invalid transferable array for structured clone/"#,
    r#"/out of bounds/"#,
    r#"/Shared memory objects must not be in the transfer list/"#,
    r#"/^Symbol\((.+)\)$/"#,
    r#"/\w+|[^\s]/g"#,
    r#"/null/"#,
    r#"/0/"#,
    r#"/12.12/"#,
    r#"/true/"#,
    r#"/false/"#,
    r#"/object/"#,
    r#"/test/"#,
    r#"/0.1/"#,
    r#"/20000/"#,
    r#"/[\u0076\u0095]/gm"#,
    r#"/a/g"#,
    r#"/a/y"#,
    r#"/0./"#,
    r#"/\\u00fd[]/"#,
    r#"/d1/ig"#,
    r#"/y/"#,
    r#"/%/g"#,
    r#"/foo(ba(r))?/"#,
    r#"/(\d+)/"#,
    r#"/missing/"#,
    r#"/^[a-z0-9\.]+$/gi"#,
    r#"/foo$/"#,
    r#"/(.*)foo$/"#,
    r#"/(str)\d*0/y"#,
    r#"/(str)\d*0/g"#,
    r#"/(str)\d*0/i"#,
    r#"/^(str)\d*0/m"#,
    r#"/str\d*0/y"#,
    r#"/str\d*0/g"#,
    r#"/str\d*0/i"#,
    r#"/^str\d*0/m"#,
    r#"/str\d+9/y"#,
    r#"/str\d+9/g"#,
    r#"/str\d+9/i"#,
    r#"/^str\d+9/m"#,
    r#"/str\d+9/"#,
    r#"/[^]/g"#,
    r#"/((?=()+))?/"#,
    r#"/abc(WHOO!)?def/y"#,
    r#"/s(\s|.)*?e/gi"#,
    r#"/incompatible/"#,
    r#"/(?:){1,60}/"#,
    r#"/(bar)?/"#,
    r#"/foo(bar)?bar/"#,
    r#"/(?!(?!(?!6)[\Wc]))/i"#,
    r#"/^[\w\-]+:\/+(?!\/)(?:[^.\/]+\.)*?reports\.adblockplus\.org(?:[\x00-\x24\x26-\x2C\x2F\x3A-\x40\x5B-\x5E\x60\x7B-\x80]|$)/i"#,
    r#"/()()()\3/"#,
    r#"/a(b)c/"#,
    r#"/(p)/"#,
    r#"/(^\n*)/"#,
    r#"/a(\w+)c/"#,
    r#"/1(\d+)3/"#,
    r#"/(?:|a)*/"#,
    r#"/^@<string>:1:1\n/"#,
    r#"/^@candelabra:6502:1\n/"#,
    r#"/\/\*DUPTRY\d+\*\//"#,
    r#"/(two|2)\s*problems/"#,
    r#"/.*(a\w).*/i"#,
    r#"/hi/g"#,
    r#"/(?:(?=g))|(?:m).{2147483648,}/"#,
    r#"/(?:(?=g)).{2147483648,}/"#,
    r#"/(X(?:.(?!X))*?Y)|(Y(?:.(?!Y))*?Z)/g"#,
    r#"/[]/"#,
    r#"/ /"#,
    r#"/^\uffff/"#,
    r#"/[&@!)OZ%3,#]/"#,
    r#"/\\\n/g"#,
    r#"/foo.*baz/"#,
    r#"/[a-z]/g"#,
    r#"/()/"#,
    r#"/a|b/g"#,
    r#"/x|a|b/g"#,
    r#"/(?:a?)*/"#,
    r#"/:/"#,
    r#"/f/"#,
    r#"/c/"#,
    r#"/\*/"#,
    r#"/n/"#,
    r#"/\)/"#,
    r#"/\\/"#,
    r#"/((x)??){2}y/"#,
    r#"/((\u66d6)??){7}J/"#,
    r#"/(a)/"#,
    r#"/(pattern)/g"#,
    r#"/foo/"#,
    r#"/.*star.*/i"#,
    r#"/can't open/"#,
    r#"/test.*[\/\\]basic[\/\\]/"#,
    r#"/(.)?@.*\n/"#,
    r#"/1/g"#,
    r#"/uDC38/ug"#,
    r#"/b/"#,
    r#"/regexp/"#,
    r#"/()()()()/"#,
    r#"/(?:(?:(")(c)")?)*/"#,
    r#"/(?:(?:a*?(")(c)")?)*/"#,
    r#"/<script\s*(?![^>]*type=['"]?(?:dojo\/|text\/html\b))(?:[^>]*?(?:src=(['"]?)([^>]*?)\1[^>]*)?)*>([\s\S]*?)<\/script>/gi"#,
    r#"/A|B/y"#,
    r#"/(x)y(z)/g"#,
    r#"/a(b)cd/g"#,
    r#"/(a)b(c)/g"#,
    r#"/(a)b(.)/g"#,
    r#"/(g)/g"#,
    r#"/^(?:\s*.){0,16}/"#,
    r#"/is not a constructor/"#,
    r#"/^@(A*)x(B)*/"#,
    r#"/\n/"#,
    r#"/[a-z]+/"#,
    r#"/(?:)/"#,
    r#"/((a|)+b)+/"#,
    r#"/.*b(cd)/"#,
    r#"/bcd.*/"#,
    r#"/.*bcd.*/"#,
    r#"/out-of-range index/"#,
    r#"/self-hosted/"#,
    r#"/^.@/"#,
    r#"/@.*$/g"#,
    r#"/@.*$/"#,
    r#"/(\d+):\d+$/"#,
    r#"/@/g"#,
    r#"/\s/g"#,
    r#"/const.*for/"#,
    r#"/for.*const/"#,
    r#"/for.*in.*uneval/"#,
    r#"/for.*for.*for/"#,
    r#"/for.*for.*gc/"#,
    r#"/\/.*[\u0000\u0080-\uffff]/"#,
    r#"/abc/g"#,
    r#"/value that doesn't coerce purely/"#,
    r#"/ \([^\)]*\)/g"#,
    r#"/fast exit trampoline to native/g"#,
    r#"/^call to( asm.js)? native .*\(in wasm\)$/g"#,
    r#"/(fast|slow) exit trampoline/g"#,
    r#"/(fast|slow) entry trampoline/g"#,
    r#"/(\/[^\/,<]+)*\/testProfiling.js/g"#,
    r#"/testBuiltinD2D/g"#,
    r#"/testBuiltinF2F/g"#,
    r#"/testBuiltinDD2D/g"#,
    r#"/assertThrowsInstanceOf/g"#,
    r#"/^ffi[12]?/g"#,
    r#"/,+/g"#,
    r#"/^,/"#,
    r#"/,$/"#,
    r#"/c$...$/"#,
    r#"/(?!()m)/"#,
    r#"/a*b/"#,
    r#"/x\d\dy/"#,
    r#"/\\r/g"#,
    r#"/\n/g"#,
    r#"/x/g"#,
    r#"/\u0024/"#,
    r#"/\u009e\u0029/g"#,
    r#"/\/\*DUPTRY\d+/"#,
    r#"/\u0042[\u0061]\\u0026/"#,
    r#"/xyz/"#,
    r#"/\u00ee[]/"#,
    r#"/[]/g"#,
    r#"/(de cuyo nombre no quiero acordarme)/"#,
    r#"/(Ἑλικωνιάδων ἀρχώμεθ᾽)/"#,
    r#"/disallowed/"#,
    r#"/foopy/"#,
    r#"/^\[object (.*)\]$/"#,
    r#"/can't start debugging: a debuggee script is on the stack/"#,
    r#"/^ds*$/"#,
    r#"/^s+Es+Es*$/"#,
    r#"/\/\*[BS]\*\//g"#,
    r#"/(\r?\n|\r|\u2028|\u2029)/g"#,
    r#"/re/"#,
    r#"/Source-url-01.js line [0-9]+ > eval/"#,
    r#"/woops/"#,
    r#"/[sy]$/"#,
    r#"/Source-url-02.js .* > Function/"#,
    r#"/LL/"#,
    r#"/^wasm:(?:[^:]*:)*?[0-9a-f]{16}$/"#,
    r#"/[^B]/g"#,
    r#"/BB/"#,
    r#"/VAL/g"#,
    r#"/.*/"#,
    r#"/debugger/"#,
    r#"/(?<x>a)|b/"#,
];
