use std::{collections::HashMap, ops::Deref, rc::Rc, thread, time::Instant};

use requests2::{
    dbfile::DBfile,
    dbfile_derive::{dbnote, DBfile},
    select::predicate::Name, Cache, Headers, Requests,
};

#[derive(DBfile)]
#[dbnote(table_name = "b339", driver = "postgres", primary_key = "href")]
struct Item<'a> {
    book_name: &'a str,
    href: String,
    img: String,
    isbn: String,
    price: f32,
}

fn create_table() {
    let by_data = Item {
        book_name: "test",
        href: "".to_string(),
        img: "".to_string(),
        isbn: "".to_string(),
        price: 6.5,
    };
    by_data.create_table();
}

fn main() {
    create_table();
    run();
}

fn run() {
    let mut urls = Vec::new();
    let now = Instant::now();
    let max_page = 30;

    for p in 1..(max_page + 1) {
        let url = format!("https://book.kongfz.com/Cxianzhuang/cat_8001w{}/", &p);
        urls.push(url);
    }

    while urls.len() > 0 {
        let mut batch_urls = Vec::new();

        for _ in 0..10 {
            if urls.len() > 0 {
                batch_urls.push(urls.remove(0));
            }
        }

        let mut handlers = Vec::new();

        for (p, url) in batch_urls.into_iter().enumerate() {
            let handler = thread::spawn(move || {
                crawl_kongfz_by_page(p as i32, url.to_string());
            });
            handlers.push(handler);
        }

        for handler in handlers {
            handler.join().unwrap();
        }
    }

    println!("cast {:?} time", now.elapsed().as_secs());
}

pub fn crawl_kongfz_by_page(page: i32, url: String) {
    let data = Cache::new();
    let client = Requests::new(&data);
    let rq = client.connect(&url, Headers::Default);

    rq.free_parse(|mut p| {
        let title = p.select("title").text();
        println!("title: -- {}", title);
    });
}
