use requests2::cache::{Person, Item};
use requests2::{Requests, Headers, Cache, Store};
use requests2::{Tool};


#[test]
fn test_hello() {
    let tool = Tool {};
    assert_eq!("hello", tool.print());
}

#[test]
    fn test_find_all() {
        let data = Cache::new();
        let client = Requests::new(&data);
        let rq = client.connect("https://www.qq.com/", Headers::Default);

        rq.parser(|p| {
            p.find_all("a", |x| {
                x.attr("href").map_or(false, |v| v.starts_with("http"))
            }, "href")
        }, "href");

        rq.parser(|p| {
            p.find_all("li", |x| {
                x.attr("class").map_or(false, |v| v.contains("nav-item"))
            }, "text")
        }, "text");

        data.print();
       
    }
