use std::collections::HashMap;
use requests2::{Cache, Requests, Store, Value, Headers};
use select::predicate::{Name, Class};
use dbfile::{DBStore};
use dbfile_derive::DBfile;


pub fn run_selector() {
    // .class .class.class #[attr=value] #id
    let cache = Cache::new();

    let rq2 = Requests::new(&cache).connect("https://news.163.com/", Headers::Default);
    rq2.parser(|mut p| {
        p.select(".news_default_news", |n| {
            let data: Vec<String> = n.iter().map(|n| n.text().split_whitespace().collect()).collect();
            Value::LIST(data)
        })
    }, "163-news");

    rq2.parser(|mut p| {
        p.select(".ns_area.list", |n| {
            let data = n.iter().map(|n| n.text().split_whitespace().collect()).collect();
            Value::LIST(data)
        })
    }, "163-tab");

    cache.print_json();

    let rq = Requests::new(&cache).connect("https://www.qq.com", Headers::Default);
    rq.parser(|mut p| {
        let attr = p.select("[bosszone=th_1]", |n| {
            let data = n.iter().map(|n| n.text().split_whitespace().collect()).collect();
            Value::LIST(data)
        });

        let class1_class2 = p.select(".tit.fl", |n| { 
            let data = n.iter().map(|n| n.text().split_whitespace().collect()).collect();
            Value::LIST(data)
        });

        let id = p.select("#searchTab", |n| {
            let data = n.into_iter().map(|n| n.text().split_ascii_whitespace().collect()).collect::<Vec<String>>();
            Value::STR(data[0].clone())
        });
        let map = HashMap::from([("attr".to_owned(), attr), ("class_class".to_owned(), class1_class2), ("id".to_owned(), id)]);
        Value::MAP(map)

    }, "qq");

    cache.print();
    let _value = cache.get("qq");
    // println!("Value: {:?}", value);
  
}


pub fn run_parser_select() {
    let data = Cache::new();
    let client = Requests::new(&data);
    let parser = client.connect("https://www.qq.com", Headers::Default);
    parser.parser(|mut p| {
        let mut result = HashMap::new();

        let navs = p.select("li.nav-item", |nodes| {
            let navs = nodes.into_iter().map(|n| {
                let mut item = HashMap::new();
                n.find(Name("a")).next().map_or(HashMap::from([("".to_string(), Value::NULL)]), |a| {
                    let nav_name = a.text();
                    let nav_href = a.attr("href").map_or(String::from(""), |x| x.to_string());
                    item.insert("nav_name".to_string(), Value::STR(nav_name));
                    item.insert("nav_href".to_string(), Value::STR(nav_href));
                    item
                })
            }).collect::<Vec<HashMap<String, Value>>>();

            Value::VECMAP(navs)
        });

        let news = p.select("ul.yw-list", |nodes| {
            let mut news = Vec::new();
            
            for node in nodes {
                for n in node.find(Class("news-top")) {
                    for a in n.find(Name("a")) {
                        let title = a.text();
                        news.push(title);
                    }
                }
            }

            Value::LIST(news)
        });

        result.insert("titles".to_owned(), news);
        result.insert("nav".to_owned(), navs);

        Value::MAP(result)
    }, "index");

    data.print();

}


pub fn run_free_parse_and_store_to_csv() {
    let data =  Cache::new();
    let client = Requests::new(&data);
    let rq = client.connect("https://www.qq.com/", Headers::Default);
    
    #[derive(DBfile, Debug)]
    struct Link<'a>{
        href: &'a str,
        link_name: String,
        title: &'a str,
    }


    rq.free_parse(|mut p| {
        
        let mut title = String::new();

        p.free_select("title", |n| title = n[0].text());

        p.free_select("li.nav-item a",| n|  {
            let links = n.iter().map(|x| {
                Link { title: &title, href: x.attr("href").expect("extra href error"), link_name: x.text() }
            }).collect::<Vec<Link>>();

            
            DBStore::to_csv(links, "D:\\links.csv", "a", true);
        });
        
    });


}