use requests2::{Requests, Headers, Cache, Store, value::Value};

#[test]
fn test_find_target_text_href() {
    let data = Cache::new();
    let client = Requests::new(&data);
    let mut rq = client.connect("https://www.qq.com", Headers::Default);
    rq.parser(|p| {
        p.find_all("a", |n| {
            n.attr("href").map_or(false, |x| x.starts_with("http:")) 
            &&
            n.parent().map_or(false, |x| x.attr("class").map_or(false, |x| x.contains("nav-item"))
            )
            &&
            n.text().contains("新闻")

        }, "href")
    }, "target_a_href");

    data.print();
    let result = data.get("target_a_href");
    match result {
        Value::LIST(d) => {
            assert_eq!(d[0], "http://news.qq.com/")
        },
        _ => ()
    }
}