
//! ## Parser 解析器 
//! 使用了类似python bs4 的结构
//! --snip--

use std::iter::Filter;

use select::{document::Document, document::Find, predicate::{Name, Predicate, Attr, And, Descendant, Class}, node::Node};
use crate::value::Value;


pub struct Parser {
    pub doc: String,
}


impl Parser {
    pub fn new(doc: String) -> Self {
        Parser {
            doc,
        }
    }

    pub fn select<F>(&self, selector: &str, mut fn_nodes: F) -> Value
    where F: FnMut(Vec<Node>) -> Value {
        
        let document = Document::from(self.doc.as_str());
        let mut tag = "";
        let mut attr = "";
        let mut value = "";

        if selector.contains(".") {
            let array: Vec<&str>= selector.split(".").collect();
            tag = array[0];
            attr = "class";
            value = array[1];
        }
        if selector.contains("#") {
            let array: Vec<&str> = selector.split("#").collect();
            tag = array[0];
            value = array[1];
            attr = "id";
        }
        let filter_nodes = document
        .find(Name(tag))
        .filter(|x| x.attr(attr).map_or(false, |v| v.contains(value)));

        let mut nodes = Vec::new();
        for node in filter_nodes {
            nodes.push(node);
        }
        fn_nodes(nodes)

        // if class_name!= "" {
        //     let d = document.find(Name(tag).and(Box::new(Class(class_name))));
        //     return fn_nodes(d);   
        // } else {
            // let d = document.find(Name(tag).and(Attr(attr, value)));
            // fn_nodes(d)
        // }

        // let nodes = document.find(Name(tag).and(Attr(attr, value)));
        // if class_name != "" {
        //     let nodes = document.find(Name(tag).and(Class(class_name)));
        // }
        // fn_nodes(nodes)
    }

    fn _find<F>(&self, tag: &str, filter: F,  attr: &str) -> Value
    where F: FnMut(&select::node::Node<'_>) -> bool {
        let data = Document::from(self.doc.as_str())
        .find(Name(tag))
        .filter(filter)
        .filter_map(|x| {
            if attr == "text" {
                Some(x.text().split_whitespace().collect::<String>())
            } else {
               Some(x.attr(attr).map_or(String::from(""), |x| x.to_string()))
            }
        }
        )
        .map(|x| x.to_string())
        .collect::<_>();
        Value::LIST(data)
    }

    pub fn find_all<F>(&self, tag: &str, filter: F,  attr: &str) -> Value 
    where F: FnMut(&select::node::Node<'_>) -> bool {
        self._find(tag, filter, attr)
    }

    pub fn find<F>(&self, tag: &str, filter: F,  attr: &str) -> Value
    where F: FnMut(&select::node::Node<'_>) -> bool {
        let data = self._find(tag, filter, attr);

        print!("{:?} ", data);
        if let Value::LIST(d) = data {
            Value::STR(d[0].clone())
        } else {
            Value::STR(String::from(""))
        }
    }
}