use requests2::{Requests, Headers, Cache, Store};

#[test]
    fn test_find_target_href() {
        let data = Cache::new();
        let client = Requests::new(&data);
        let mut rq = client.connect("https://www.qq.com", Headers::Default);
        rq.parser(|p| {
            p.find_all("a", |n| {
                n.attr("href").map_or(false, |x| x.starts_with("http:")) 
                &&
                n.parent().map_or(false, |x| x.attr("class").map_or(false, |x| x.contains("nav-item"))
                )

            }, "href")
        }, "target_a_href");

        data.print();
        let count = data.count("target_a_href");
        assert_eq!(count, 14);
    }