
//! ## Parser 解析器 
//! 使用了类似python bs4 的结构
//! --snip--

use select::{document::Document, predicate::Name};
use crate::value::Value;


pub struct Parser {
    pub doc: String,
}

impl Parser {
    pub fn new(doc: String) -> Self {
        Parser {
            doc,
        }
    }

    fn _find<F>(&self, tag: &str, filter: F,  attr: &str) -> Value
    where F: FnMut(&select::node::Node<'_>) -> bool {
        let data = Document::from(self.doc.as_str())
        .find(Name(tag))
        .filter(filter)
        .filter_map(|x| {
            if attr == "text" {
                Some(x.text().split_whitespace().collect::<String>())
            } else {
               Some(x.attr(attr).map_or(String::from(""), |x| x.to_string()))
            }
        }
        )
        .map(|x| x.to_string())
        .collect::<_>();
        Value::LIST(data)
    }

    pub fn find_all<F>(&self, tag: &str, filter: F,  attr: &str) -> Value 
    where F: FnMut(&select::node::Node<'_>) -> bool {
        self._find(tag, filter, attr)
    }

    pub fn find<F>(&self, tag: &str, filter: F,  attr: &str) -> Value
    where F: FnMut(&select::node::Node<'_>) -> bool {
        let data = self._find(tag, filter, attr);
        if let Value::LIST(d) = data {
            Value::STR(d[0].clone())
        } else {
            Value::STR(String::from(""))
        }
    }
}