use super::*;

#[test]
fn take() {
    assert_eq!(Segment::take_until_sep("myfile").unwrap(), "myfile");
    assert_eq!(Segment::take_until_sep("my/file").unwrap(), "my");
    assert_eq!(Segment::take_until_sep("my/").unwrap(), "my");
    assert_eq!(Segment::take_until_sep("/file").unwrap(), "");
    assert_eq!(Segment::take_until_sep("/").unwrap(), "");
    assert_eq!(Segment::take_until_sep("").unwrap(), "");
}

fn lbl(s: &str) -> Label {
    Label::try_from(s).expect(s)
}

#[test]
fn lbl_relative_empty() {
    assert_eq!(lbl("").segments, vec![Segment::Empty]);
}

#[test]
fn lbl_relative_simple() {
    assert_eq!(lbl("myfile").segments, vec![Segment::file("myfile")]);
    assert_eq!(lbl(":myrule").segments, vec![Segment::rule("myrule")]);
    assert_eq!(lbl("mydir/").segments, vec![Segment::dir("mydir")]);
}

#[test]
fn lbl_relative_compound() {
    assert_eq!(lbl("my/foo").segments, vec![Segment::dir("my"), Segment::file("foo")]);
    assert_eq!(lbl("my/:foo").segments, vec![Segment::dir("my"), Segment::rule("foo")]);
    assert_eq!(lbl("my/foo/").segments, vec![Segment::dir("my"), Segment::dir("foo")]);
}
