use aoko::no_std::pipelines::{pipe::Pipe, tap::Tap};
use itertools::Itertools;
use repoer::cmp;
use serde_json::Value;
use std::{env::args, fs};

fn main() {
    let file_name = &args().collect_vec()[1];
    let json = fs::read(file_name).unwrap();
    let data: Value = serde_json::from_slice(json.as_slice()).unwrap();
    let init = r#"security scan report for xxxxx
Lunaray目前已经启动月神计划（projectluna），通过对区块链生态中的去中心化项目进行智能合约安全扫描，尽可能的发现智能合约中的安全问题，减少资产损失。
报告声明：本扫描结果只针对常规安全漏洞进行扫描，不做为最终的合约安全审计结果，也不作为用户的投资建议，如有疑问请联系support@lunaray.co。
代币：xxxxx
链：xxxxx
合约：xxxxx
风险等级：xxxxx
本次扫描工具：Lunaray Contract Security Scanner
扫描结果：通过对 xxxxx 合约进行扫描，发现存在如下安全风险：

"#;

    if let Value::Object(vul_map) = data {
        vul_map.values().for_each(|arr| {
            if let Value::Array(vec) = arr {
                vec.iter()
                    .map(|ele| {
                        if let Value::Object(map) = ele {
                            map
                        } else {
                            panic!("internal error")
                        }
                    })
                    .into_group_map_by(|map| {
                        if let Value::String(s) = map.get("name").unwrap() {
                            s
                        } else {
                            panic!("internal error")
                        }
                    })
                    .iter()
                    .sorted_by(|(_, v1), (_, v2)| {
                        if let Value::String(s1) = v1[0].get("risk").unwrap() {
                            if let Value::String(s2) = v2[0].get("risk").unwrap() {
                                cmp(s1, s2)
                            } else {
                                panic!("internal error")
                            }
                        } else {
                            panic!("internal error")
                        }
                    })
                    .rev()
                    .fold(init.to_string(), |acc, (name, vec)| {
                        let v = vec[0];
                        acc + &format!(
                            "● [{}] {}\n○ advice: {}\n\n",
                            v.get("risk").unwrap(),
                            name,
                            if let Value::String(s) = v.get("advice").unwrap() {
                                s.split_whitespace().filter(|s| !s.is_empty()).join(" ")
                            } else {
                                panic!("internal error")
                            }
                        )
                    })
                    .tap_mut(|s| s.push_str(r#"报告到此为止"#))
                    .pipe(|s| {
                        fs::write(file_name.trim_end_matches(".json").to_string() + ".txt", s)
                    })
                    .unwrap();
            }
        })
    }
}
