use std::cmp::Ordering;
use Ordering::*;

pub fn cmp(a: &str, b: &str) -> Ordering {
    match (a, b) {
        // Greater:
        ("high", "medium" | "low" | "info") => Greater,
        ("medium", "low" | "info") => Greater,
        ("low", "info") => Greater,

        // Equal:
        ("high", "high") => Equal,
        ("medium", "medium") => Equal,
        ("low", "low") => Equal,
        ("info", "info") => Equal,

        // Less:
        ("info", "low" | "medium" | "high") => Less,
        ("low", "medium" | "high") => Less,
        ("medium", "high") => Less,

        // Others => panic:
        _ => panic!("internal cmp error"),
    }
}
