#![allow(dead_code)]
#![allow(unused_imports)]

#[macro_use]
extern crate log;

pub use cache::Cache;
pub use location::Location;
pub use query::{Query, ScpPath};
pub use remote::Remote;
pub use repository::{Repository, RepositoryBuilder};
pub use tag::{Tag, TagBuilder};
pub use workspace::Workspace;

pub mod prelude;
pub mod shell;
pub mod util;

mod cache;
mod config;
mod git;
mod location;
mod query;
mod remote;
mod repository;
mod tag;
mod workspace;
