extern crate proc_macro;
use proc_macro::TokenStream;

#[proc_macro_attribute]
pub fn replify(_attr: TokenStream, input: TokenStream) -> TokenStream {
    let mut code = String::new();
    let mut last_char = ' ';
    let mut times = 0;
    for i in input.to_string().chars() {
        if last_char == '(' && times == 0 {
            code.push_str("_data: std::collections::HashMap<String, std::sync::Arc<dyn std::any::Any>>,");
            times += 1
        };
        code.push(i);
        last_char = i;
    }
    code.parse().unwrap()
}
