//! ## Mock
//!
//! Contains mock for test units

/**
 * MIT License
 *
 * remotefs - Copyright (c) 2021 Christian Visintin
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
use crate::RemoteFs;

#[cfg(feature = "ssh")]
pub mod ssh;

// -- logger

pub fn logger() {
    let _ = env_logger::builder().is_test(true).try_init();
}

// -- mock
pub struct MockRemoteFs;

impl RemoteFs for MockRemoteFs {
    #[allow(unused)]
    fn connect(&mut self) -> crate::RemoteResult<crate::fs::Welcome> {
        Ok(crate::fs::Welcome::default())
    }

    #[allow(unused)]
    fn disconnect(&mut self) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn is_connected(&mut self) -> bool {
        true
    }

    #[allow(unused)]
    fn pwd(&mut self) -> crate::RemoteResult<std::path::PathBuf> {
        Ok(std::path::PathBuf::from("/"))
    }

    #[allow(unused)]
    fn change_dir(&mut self, dir: &std::path::Path) -> crate::RemoteResult<std::path::PathBuf> {
        Ok(dir.to_path_buf())
    }

    #[allow(unused)]
    fn list_dir(&mut self, path: &std::path::Path) -> crate::RemoteResult<Vec<crate::Entry>> {
        Ok(vec![])
    }

    #[allow(unused)]
    fn stat(&mut self, path: &std::path::Path) -> crate::RemoteResult<crate::Entry> {
        Ok(crate::Entry::File(crate::File {
            name: "foo".to_string(),
            path: std::path::PathBuf::from("/foo"),
            extension: None,
            metadata: crate::fs::Metadata::default(),
        }))
    }

    #[allow(unused)]
    fn setstat(
        &mut self,
        path: &std::path::Path,
        metadata: crate::fs::Metadata,
    ) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn exists(&mut self, path: &std::path::Path) -> crate::RemoteResult<bool> {
        Ok(true)
    }

    #[allow(unused)]
    fn remove_file(&mut self, path: &std::path::Path) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn remove_dir(&mut self, path: &std::path::Path) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn create_dir(
        &mut self,
        path: &std::path::Path,
        mode: crate::fs::UnixPex,
    ) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn symlink(
        &mut self,
        path: &std::path::Path,
        target: &std::path::Path,
    ) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn copy(&mut self, src: &std::path::Path, dest: &std::path::Path) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn mov(&mut self, src: &std::path::Path, dest: &std::path::Path) -> crate::RemoteResult<()> {
        Ok(())
    }

    #[allow(unused)]
    fn exec(&mut self, cmd: &str) -> crate::RemoteResult<(u32, String)> {
        Ok((0, String::default()))
    }

    #[allow(unused)]
    fn append(
        &mut self,
        path: &std::path::Path,
        metadata: &crate::fs::Metadata,
    ) -> crate::RemoteResult<Box<dyn std::io::Write>> {
        Err(crate::RemoteError::new(
            crate::RemoteErrorType::UnsupportedFeature,
        ))
    }

    #[allow(unused)]
    fn create(
        &mut self,
        path: &std::path::Path,
        metadata: &crate::fs::Metadata,
    ) -> crate::RemoteResult<Box<dyn std::io::Write>> {
        Err(crate::RemoteError::new(
            crate::RemoteErrorType::UnsupportedFeature,
        ))
    }

    #[allow(unused)]
    fn open(&mut self, path: &std::path::Path) -> crate::RemoteResult<Box<dyn std::io::Read>> {
        Err(crate::RemoteError::new(
            crate::RemoteErrorType::UnsupportedFeature,
        ))
    }
}
