//! Convenience re-export of common members.
//!
//! Like the standard library's prelude, this module simplifies importing of common items.
//! Unlike the standard prelude, the contents of this module must be imported manually.
//!
//! ```
//! use remoc::prelude::*;
//! ```
//!

pub use crate::chmux;

#[cfg(feature = "rch")]
pub use crate::rch;

#[cfg(feature = "rch")]
#[doc(no_inline)]
pub use crate::RemoteSend;

#[cfg(feature = "rfn")]
pub use crate::rfn;

#[cfg(feature = "robj")]
pub use crate::robj;

#[cfg(feature = "rtc")]
pub use crate::rtc;

#[cfg(feature = "rtc")]
#[doc(no_inline)]
pub use crate::rtc::{Client, Server, ServerRef, ServerRefMut, ServerShared, ServerSharedMut};
