use adw::prelude::AdwApplicationWindowExt;
use gtk::prelude::{BoxExt, ButtonExt, GtkWindowExt, OrientableExt};
use relm4::{
    adw,
    factory::{DynamicIndex, FactoryPrototype, FactoryVecDeque},
    gtk, send, AppUpdate, Model, RelmApp, Sender, WidgetPlus, Widgets,
};

#[derive(Debug, Default)]
struct Tab {
    index: u8,
}

#[derive(Debug, Default)]
struct TabWidgets {
    label: gtk::Label,
}

impl FactoryPrototype for Tab {
    type Factory = FactoryVecDeque<Tab>;
    type View = adw::TabView;
    type Msg = AppMsg;
    type Widgets = TabWidgets;
    type Root = gtk::Label;

    fn init_view(&self, _key: &DynamicIndex, _sender: Sender<Self::Msg>) -> Self::Widgets {
        TabWidgets {
            label: gtk::Label::new(Some(&self.index.to_string())),
        }
    }

    fn position(&self, _key: &DynamicIndex) {}

    fn view(&self, _key: &DynamicIndex, _widgets: &Self::Widgets) {}

    fn root_widget(widgets: &Self::Widgets) -> &Self::Root {
        &widgets.label
    }
}

#[derive(Default)]
struct AppModel {
    counter: u8,
    _tabs: FactoryVecDeque<Tab>,
}

enum AppMsg {
    Increment,
    Decrement,
}

impl Model for AppModel {
    type Msg = AppMsg;
    type Widgets = AppWidgets;
    type Components = ();
}

impl AppUpdate for AppModel {
    fn update(&mut self, msg: AppMsg, _components: &(), _sender: Sender<AppMsg>) -> bool {
        match msg {
            AppMsg::Increment => {
                self.counter = self.counter.wrapping_add(1);
            }
            AppMsg::Decrement => {
                self.counter = self.counter.wrapping_sub(1);
            }
        }
        true
    }
}

#[relm4::widget]
impl Widgets<AppModel, ()> for AppWidgets {
    view! {
        main_window = adw::ApplicationWindow {
            set_default_width: 300,
            set_default_height: 200,

            set_content: main_box = Some(&gtk::Box) {
                set_orientation: gtk::Orientation::Vertical,

                append = &adw::HeaderBar {
                    set_title_widget = Some(&gtk::Label) {
                        set_label: "Title!",
                    }
                },
                append = &gtk::Box {
                    set_orientation: gtk::Orientation::Vertical,
                    set_margin_all: 5,
                    set_spacing: 5,

                    append = &gtk::Button {
                        set_label: "Increment",
                        connect_clicked(sender) => move |_| {
                            send!(sender, AppMsg::Increment);
                        },
                    },
                    append = &gtk::Button {
                        set_label: "Decrement",
                        connect_clicked(sender) => move |_| {
                            send!(sender, AppMsg::Decrement);
                        },
                    },
                    append = &gtk::Label {
                        set_margin_all: 5,
                        set_label: watch! { &format!("Counter: {}", model.counter) },
                    }
                }
            },
        }
    }
}

fn main() {
    let model = AppModel::default();
    let app = RelmApp::new(model);
    app.run();
}
