use adw::prelude::{AdwApplicationWindowExt, AnimationExt};
use gtk::prelude::{BoxExt, GtkWindowExt, OrientableExt, WidgetExt};
use relm4::{adw, gtk, send, AppUpdate, Model, RelmApp, Sender, WidgetPlus, Widgets};

#[derive(Default)]
struct AppModel {
    counter: u8,
}

enum AppMsg {
    Increment,
    Decrement,
}

impl Model for AppModel {
    type Msg = AppMsg;
    type Widgets = AppWidgets;
    type Components = ();
}

impl AppUpdate for AppModel {
    fn update(&mut self, msg: AppMsg, _components: &(), _sender: Sender<AppMsg>) -> bool {
        match msg {
            AppMsg::Increment => {
                self.counter = self.counter.wrapping_add(1);
            }
            AppMsg::Decrement => {
                self.counter = self.counter.wrapping_sub(1);
            }
        }
        true
    }
}

#[relm4::widget]
impl Widgets<AppModel, ()> for AppWidgets {
    view! {
        main_window = adw::ApplicationWindow {
            set_content: main_box = Some(&gtk::Box) {
                set_orientation: gtk::Orientation::Vertical,

                append = &adw::HeaderBar {
                    set_title_widget = Some(&gtk::Label) {
                        set_label: "Relm4 example",
                    }
                },

                append = &gtk::Label {
                    set_label: "Hello TWIG!",
                    set_css_classes: &["title-1", "accent"],
                    set_margin_all: 12,
                }
            }
        }
    }

    // set_default_width: 300,
    // set_default_height: 200,

    // set_content: main_box = Some(&gtk::Box) {
    //     set_orientation: gtk::Orientation::Vertical,

    //     append = &adw::HeaderBar {
    //         set_title_widget = Some(&gtk::Label) {
    //             set_label: "Title!",
    //         }
    //     },
    //     append = &gtk::Box {
    //         set_orientation: gtk::Orientation::Vertical,
    //         set_margin_all: 5,
    //         set_spacing: 5,

    //         append = &gtk::Button {
    //             set_label: "Increment",
    //             connect_clicked(sender) => move |_| {
    //                 send!(sender, AppMsg::Increment);
    //             },
    //         },
    //         append = &gtk::Button {
    //             set_label: "Decrement",
    //             connect_clicked(sender) => move |_| {
    //                 send!(sender, AppMsg::Decrement);
    //             },
    //         },
    //         append: label = &gtk::Label {
    //             set_margin_all: 5,
    //             set_label: watch! { &format!("Counter: {}", model.counter) },
    //         }
    //     }
    // },
    //}
    //}

    // fn post_init() {
    //     let animation_target = adw::CallbackAnimationTarget::new(Some(Box::new(|num| println!("{}", num))));
    //     let animation = adw::TimedAnimation::new(&label, 0.0, 1.0, 1, &animation_target);
    //     animation.play();

    // }
}

fn main() {
    let model = AppModel::default();
    let app = RelmApp::new(model);
    app.run();
}
