//! Module providing an accelerator builder.

#[derive(Default, Debug)]
/// Builder for keyboard accelerators
pub struct AccelsBuilder {
    shift_mask: bool,
    control_mask: bool,
    alt_mask: bool,
    super_mask: bool,
    // meta_mask: bool,
    // hyper_mask: bool,
}

impl AccelsBuilder {
    /// Create a new [`AccelsBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    /// Add a `SHIFT` key to the accelerator.
    pub fn add_shift(mut self) -> Self {
        self.shift_mask = true;
        self
    }

    /// Add a `CONTROL` key to the accelerator.
    pub fn add_control(mut self) -> Self {
        self.control_mask = true;
        self
    }

    /// Add a `ALT` key to the accelerator.
    pub fn add_alt(mut self) -> Self {
        self.alt_mask = true;
        self
    }

    /// Add a `SUPER` key to the accelerator.
    pub fn add_super(mut self) -> Self {
        self.super_mask = true;
        self
    }

    // pub fn add_meta(mut self) -> Self {
    //     self.meta_mask = true;
    //     self
    // }

    // pub fn add_hyper(mut self) -> Self {
    //     self.hyper_mask = true;
    //     self
    // }

    pub fn finish(self, key: &str) -> String {
        let mut output = String::new();
        if self.control_mask {
            output.push_str("<Control>");
        }
        if self.shift_mask {
            output.push_str("<Shift>");
        }
        if self.alt_mask {
            output.push_str("<Alt>");
        }
        if self.super_mask {
            output.push_str("<Super>");
        }
        // if self.meta_mask {
        //     output.push_str("<Meta>");
        // }
        // if self.hyper_mask {
        //     output.push_str("<Hyper>");
        // }

        output.push_str(key);

        output
    }
}
