


use glib::{subclass, subclass::Signal, types, ParamFlags, ParamSpec, Value};
use gtk::cairo;
use gtk::gsk;
use gtk::prelude::{Cast, ObjectExt, StaticType, ToValue};
use gtk::subclass::prelude::{ObjectImpl, ObjectSubclass, PaintableImpl};
use gtk::{gdk, glib, graphene};
use once_cell::sync::Lazy;

use std::cell::{Cell, RefCell};

mod imp {
    use super::*;
    pub struct CairoArea {
        pub width: Cell<Option<f64>>,
        pub height: Cell<Option<f64>>,
        pub node: RefCell<gsk::CairoNode>,
        //pub redraw_fn: RefCell<Option<Box<dyn Fn()>>>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for CairoArea {
        const NAME: &'static str = "CairoArea";
        type Type = super::CairoArea;
        type ParentType = glib::Object;
        type Instance = subclass::basic::InstanceStruct<Self>;
        type Class = subclass::basic::ClassStruct<Self>;
        type Interfaces = (gdk::Paintable,);

        fn new() -> Self {
            let node = gsk::CairoNode::new(&graphene::Rect::new(0f32, 0f32, 0f32, 0f32));
            Self {
                width: Cell::new(None),
                height: Cell::new(None),
                node: RefCell::new(node),
            }
        }
    }

    impl ObjectImpl for CairoArea {
        fn properties() -> &'static [ParamSpec] {
            static PROPERTIES: Lazy<Vec<ParamSpec>> = Lazy::new(|| {
                vec![ParamSpec::new_object(
                    // Name
                    "draw-context",
                    // Nickname
                    "draw context",
                    // Short description
                    "cairo draw context",
                    // Minimum value
                    types::Type::OBJECT,
                    // The property can be read and written to
                    ParamFlags::READABLE,
                )]
            });
            PROPERTIES.as_ref()
        }

        fn set_property(&self, _obj: &Self::Type, _id: usize, _value: &Value, _pspec: &ParamSpec) {
            unimplemented!()
        }

        fn property(&self, _obj: &Self::Type, _id: usize, pspec: &ParamSpec) -> Value {
            match pspec.name() {
                "draw-context" => { let cx = self.node.borrow().draw_context().unwrap();
            println!("Init -> {:?}", cx.to_raw_none());
        //cx.set_source_rgb(0.0, 1.0, 0.0);
        //cx.move_to(0.0, 0.0);
        //cx.line_to(100.0, 100.0);
        //cx.stroke().unwrap();
                 cx.to_value() },
                _ => unimplemented!(),
            }
        }

        /*fn signals() -> &'static [Signal] {
            static SIGNALS: Lazy<Vec<Signal>> = Lazy::new(|| {
                vec![Signal::builder(
                    // Signal name
                    "redraw",
                    // Types of the values which will be sent to the signal handler
                    &[cairo::Context::static_type().into()],
                    // Type of the value the signal handler sends back
                    <()>::static_type().into(),
                )
                .build()]
            });
            SIGNALS.as_ref()
        }*/
    }

    impl PaintableImpl for CairoArea {
        fn intrinsic_height(&self, _paintable: &Self::Type) -> i32 {
            //self.height.get().map(|num| num as i32).unwrap_or(-1)
            -1
        }

        fn intrinsic_width(&self, _paintable: &Self::Type) -> i32 {
            //self.width.get().map(|num| num as i32).unwrap_or(-1)
            -1
        }

        fn snapshot(
            &self,
            _paintable: &Self::Type,
            snapshot: &gdk::Snapshot,
            width: f64,
            height: f64,
        ) {
            let self_height = self.height.get();
            let self_width = self.width.get();

            //if self_height != Some(height) || self_width != Some(width) {
                self.node.replace(gsk::CairoNode::new(&graphene::Rect::new(
                    0f32,
                    0f32,
                    width as f32,
                    height as f32,
                )));
                self.width.set(Some(width));
                self.height.set(Some(height));

                println!("Re-init");

                //println!("Redraw??? -> {}", self.redraw_fn.borrow().is_some());
                //if let Some(fun) = &*self.redraw_fn.borrow() {
                //    fun();
                //}
                /*self.upcast()
                .emit_by_name("redraw", &[&self.node.borrow().draw_context().unwrap()])
                .expect("Could not emit signal.");*/
            //}
            let node = self.node.borrow();
            let cx = node.draw_context().unwrap();
            println!("Snap -> {:?}", cx.to_raw_none());

            static mut OFFSET: f64 = 0.0;

            let offset = unsafe {
                OFFSET += 1.0;
                OFFSET
            };
            let snapshot = snapshot.downcast_ref::<gtk::Snapshot>().unwrap();
            snapshot.append_node(&*node);

        cx.set_source_rgb(0.0, 0.5, 1.0);
        cx.move_to(100.0, 0.0);
        cx.line_to(0.0, offset);
        cx.stroke().unwrap();
        }
    }
}

impl CairoArea {
    pub fn draw_context(&self) -> cairo::Context {
        self.property("draw-context")
            .expect("Couldn't find property draw-context")
            .get::<cairo::Context>()
            .expect("Property draw-context isn't a cairo::Context")
    }

    /*pub fn connect_redraw<F: Fn() + 'static>(&self, fun: F) {
        self.connect_local("redraw", false, move |_args| {
            fun();
            None
        })
        .expect("Couldn't connect redraw signal");
    }*/
}

glib::wrapper! {
    pub struct CairoArea(ObjectSubclass<imp::CairoArea>) @implements gdk::Paintable;
}

impl Default for CairoArea {
    fn default() -> Self {
        Self::new()
    }
}

impl CairoArea {
    pub fn new() -> Self {
        glib::Object::new(&[]).expect("Failed to create object of type CairoArea")
    }

    // Loads the bytes of a GIF into the paintable
    // The loading consists of decoding the gif with a GIFDecoder
    // Then storing the frames so that the paintable can render them
    //
    // You can only call this function once due to the callback system in setup_next_frame
    // causing the frames to refresh at faster intervals
    /*pub fn load_from_bytes(&self) -> Result<(), Box<dyn std::error::Error>> {
        let self_ = imp::CairoArea::from_instance(self);

        // make sure the first frame is queued to play
        self.setup_next_frame();

        Ok(())
    }

    fn setup_next_frame(&self) {
        let self_ = imp::CairoArea::from_instance(self);

        // invalidate the contents so that the new frame will be rendered
        self.invalidate_contents();

        // setup a callback to this function once the frame has finished so that
        // we can play the next frame
        let update_next_frame_callback = glib::clone!(@weak self as paintable => move || {
            paintable.setup_next_frame();
        });
    }*/
}

/*fn main() {
    let application = Application::new(Some("com.github.gtk-rs.gif-paintable"), Default::default());

    application.connect_activate(move |app| {
        let child = CairoArea::new();

        let picture = Picture::builder().paintable(&child).build();
        let win = ApplicationWindow::builder()
            .application(app)
            .child(&picture)
            .build();

        win.show();
    });

    application.run();
}*/
