//! Default widget implementation.
///
/// This is mainly useful for macros that generate widgets
/// in order to avoid passing arguments to `new(...)` functions of GTK widgets.
pub trait DefaultWidget {
    /// Returns a widget with default configuration
    fn default_widget() -> Self;
}

macro_rules! impl_default_widget {
    ($name:ty) => {
        impl DefaultWidget for $name {
            fn default_widget() -> Self {
                Self::builder().build()
            }
        }
    };
}

macro_rules! impl_default_widgets {
    [$($name:ty),+] => {
        $(impl_default_widget!($name);)+
    };
}

#[cfg(target_os = "linux")]
impl_default_widgets![
    gtk::PageSetupUnixDialog,
    gtk::PrintJob,
    gtk::PrintUnixDialog,
    gtk::Printer
];

#[cfg(feature = "libadwaita")]
#[cfg_attr(doc, doc(cfg(feature = "libadwaita")))]
impl_default_widgets![
    adw::ActionRow,
    adw::ApplicationWindow,
    adw::Avatar,
    adw::Bin,
    adw::Carousel,
    adw::CarouselIndicatorDots,
    adw::CarouselIndicatorLines,
    adw::Clamp,
    adw::ClampLayout,
    adw::ClampScrollable,
    adw::ExpanderRow,
    adw::Flap,
    adw::HeaderBar,
    adw::Leaflet,
    adw::PreferencesGroup,
    adw::PreferencesPage,
    adw::PreferencesRow,
    adw::PreferencesWindow,
    adw::Squeezer,
    adw::StatusPage,
    adw::SwipeTracker,
    adw::TabBar,
    adw::TabView,
    adw::ViewSwitcher,
    adw::ViewSwitcherBar,
    adw::ViewSwitcherTitle,
    adw::Window,
    adw::WindowTitle
];

impl_default_widgets![
    gtk::AboutDialog,
    gtk::ActionBar,
    gtk::Adjustment,
    gtk::AlternativeTrigger,
    gtk::AppChooserButton,
    gtk::AppChooserDialog,
    gtk::AppChooserWidget,
    gtk::Application,
    gtk::ApplicationWindow,
    gtk::AspectFrame,
    gtk::Assistant,
    gtk::BoolFilter,
    gtk::Box,
    gtk::BoxLayout,
    gtk::Button,
    gtk::Calendar,
    gtk::CellAreaBox,
    gtk::CellRendererAccel,
    gtk::CellRendererCombo,
    gtk::CellRendererPixbuf,
    gtk::CellRendererProgress,
    gtk::CellRendererSpin,
    gtk::CellRendererSpinner,
    gtk::CellRendererText,
    gtk::CellRendererToggle,
    gtk::CellView,
    gtk::CenterBox,
    gtk::CheckButton,
    gtk::ColorButton,
    gtk::ColorChooserDialog,
    gtk::ColorChooserWidget,
    gtk::ColumnView,
    gtk::ColumnViewColumn,
    gtk::ComboBox,
    gtk::ComboBoxText,
    gtk::Constraint,
    gtk::ConstraintGuide,
    gtk::ConstraintLayoutChild,
    gtk::Dialog,
    gtk::DragIcon,
    gtk::DragSource,
    gtk::DrawingArea,
    gtk::DropControllerMotion,
    gtk::DropDown,
    gtk::DropTarget,
    gtk::DropTargetAsync,
    gtk::EditableLabel,
    gtk::EmojiChooser,
    gtk::Entry,
    gtk::EntryBuffer,
    gtk::EntryCompletion,
    gtk::EventControllerFocus,
    gtk::EventControllerKey,
    gtk::EventControllerLegacy,
    gtk::EventControllerMotion,
    gtk::EventControllerScroll,
    gtk::Expander,
    gtk::FileChooserDialog,
    gtk::FileChooserNative,
    gtk::FileChooserWidget,
    gtk::FilterListModel,
    gtk::Fixed,
    gtk::FixedLayoutChild,
    gtk::FlowBox,
    gtk::FlowBoxChild,
    gtk::FontButton,
    gtk::FontChooserDialog,
    gtk::FontChooserWidget,
    gtk::Frame,
    gtk::GLArea,
    gtk::GestureClick,
    gtk::GestureDrag,
    gtk::GestureLongPress,
    gtk::GesturePan,
    gtk::GestureRotate,
    gtk::GestureStylus,
    gtk::GestureSwipe,
    gtk::GestureZoom,
    gtk::Grid,
    gtk::GridLayout,
    gtk::GridLayoutChild,
    gtk::GridView,
    gtk::HeaderBar,
    gtk::IMContextSimple,
    gtk::IMMulticontext,
    gtk::IconPaintable,
    gtk::IconTheme,
    gtk::IconView,
    gtk::Image,
    gtk::InfoBar,
    gtk::Label,
    gtk::LevelBar,
    gtk::LinkButton,
    gtk::ListBox,
    gtk::ListBoxRow,
    gtk::ListView,
    gtk::LockButton,
    gtk::MediaControls,
    gtk::MenuButton,
    gtk::MessageDialog,
    gtk::MountOperation,
    gtk::Notebook,
    gtk::NumericSorter,
    gtk::Overlay,
    gtk::OverlayLayoutChild,
    gtk::PadController,
    gtk::Paned,
    gtk::PasswordEntry,
    gtk::Picture,
    gtk::Popover,
    gtk::PopoverMenu,
    gtk::PopoverMenuBar,
    gtk::PrintOperation,
    gtk::ProgressBar,
    gtk::Revealer,
    gtk::Scale,
    gtk::ScaleButton,
    gtk::Scrollbar,
    gtk::ScrolledWindow,
    gtk::SearchBar,
    gtk::SearchEntry,
    gtk::Separator,
    gtk::Settings,
    gtk::Shortcut,
    gtk::ShortcutController,
    gtk::ShortcutLabel,
    gtk::ShortcutsGroup,
    gtk::ShortcutsSection,
    gtk::ShortcutsShortcut,
    gtk::ShortcutsWindow,
    gtk::SingleSelection,
    gtk::SliceListModel,
    gtk::SortListModel,
    gtk::SpinButton,
    gtk::Spinner,
    gtk::Stack,
    gtk::StackSidebar,
    gtk::StackSwitcher,
    gtk::Statusbar,
    gtk::StringFilter,
    gtk::StringSorter,
    gtk::Switch,
    gtk::Text,
    gtk::TextBuffer,
    gtk::TextMark,
    gtk::TextTag,
    gtk::TextView,
    gtk::ToggleButton,
    gtk::TreeExpander,
    gtk::TreeListModel,
    gtk::TreeView,
    gtk::TreeViewColumn,
    gtk::Video,
    gtk::Viewport,
    gtk::VolumeButton,
    gtk::Window,
    gtk::WindowControls,
    gtk::WindowHandle,
    gtk::Border
];
