# Release Management

[![Build status](https://github.com/stepchowfun/release-management/workflows/Continuous%20integration/badge.svg?branch=main)](https://github.com/stepchowfun/release-management/actions?query=branch%3Amain)

This is a simple project to demonstrate the release management process for my open source work.

## Installation instructions

### Easy installation on macOS or Linux

If you are running macOS or Linux on an x86-64 CPU, you can install Release Management with this command:

```sh
curl https://raw.githubusercontent.com/stepchowfun/release-management/main/install.sh -LSfs | sh
```

The same command can be used again to update Release Management to the latest version.

**NOTE:** Piping `curl` to `sh` is considered dangerous by some since the server might be compromised. If you're concerned about this, you can download and inspect the installation script or choose one of the other installation methods.

**NOTE:** The installation script requires `curl`. Most macOS and Linux machines have `curl` installed by default.

#### Customizing the installation

The installation script supports the following environment variables:

- `VERSION=x.y.z` (defaults to the latest version)
- `PREFIX=/path/to/install` (defaults to `/usr/local/bin`)

For example, the following will install Release Management into the working directory:

```sh
curl https://raw.githubusercontent.com/stepchowfun/release-management/main/install.sh -LSfs | PREFIX=. sh
```

### Manual installation for macOS, Linux, or Windows

The [releases page](https://github.com/stepchowfun/release-management/releases) has precompiled binaries for macOS, Linux, and Windows systems running on an x86-64 CPU. You can download one of them and place it in a directory listed in your [`PATH`](https://en.wikipedia.org/wiki/PATH_\(variable\)).

### Installation with Cargo

If you have [Cargo](https://doc.rust-lang.org/cargo/), you can install Release Management as follows:

```sh
cargo install release-management
```

You can run that command with `--force` to update an existing installation.

## For maintainers

### Release instructions

1. Bump the version in `Cargo.toml`, run `cargo build` to update `Cargo.lock`, and update `CHANGELOG.md` with information about the new version. Ship those changes as a single commit.
2. Once the GitHub workflow has finished on the `main` branch, update the version in `install.sh` to point to the new release.

### GitHub instructions

When setting up the project, change the following settings:

- Under `Secrets`, add the following repository secrets with appropriate values:
  - `CRATES_IO_TOKEN`
  - `DOCKER_PASSWORD`
- Under `Branches`, add a branch protection rule for the `main` branch.
  - Enable `Require status checks to pass before merging`.
    - Enable `Require branches to be up to date before merging`.
    - Add the following status checks:
      - `Build and test on Linux`
      - `Build and test on macOS`
      - `Build and test on Windows`
  - Enable `Include administrators`.
- Under `Options`, enable `Automatically delete head branches`.
