# Release Management

[![Build status](https://github.com/stepchowfun/release-management/workflows/Continuous%20integration/badge.svg?branch=main)](https://github.com/stepchowfun/release-management/actions?query=branch%3Amain)

This is a simple project to demonstrate the release management process for my open source work.

## Release instructions

Bump the version in `Cargo.toml`, run `cargo build` to update `Cargo.lock`, and update `CHANGELOG.md` with information about the new version. Ship those changes as a single commit.

## GitHub instructions

When setting up the project, change the following settings:

- Under `Secrets`, add the following repository secrets with appropriate values:
  - `CRATES_IO_TOKEN`
  - `DOCKER_PASSWORD`
- Under `Branches`, add a branch protection rule for the `main` branch.
  - Enable `Require status checks to pass before merging`.
    - Enable `Require branches to be up to date before merging`.
    - Add the following status checks:
      - `Build and test on Linux`
      - `Build and test on macOS`
      - `Build and test on Windows`
  - Enable `Include administrators`.
- Under `Options`, enable `Automatically delete head branches`.
