# Relastic

Simple rust lib inspired by Serilog for application-wide logging:

- Application wide logs
- Posting logs to Elastic to access them with Kibana

## Purpose

<!-- What does the application do and why? What problem does it solve? -->

Log to Elastic from Rust applications

## Intended consumers

<!--  Who is the application intended for, and who can utilize its features? -->

Everyone. Do not use in production without first assessing the risks involved.

## Main technologies

<!-- What are the main languages and frameworks are used in the project -->

- Rust
- NixShell

## Available at

<!-- If the application is live, mention where it can be 'viewed' and where it is deployed, e.g. OpenShift, Azure etc. -->
<!-- For libraries, this might also include what package repository it's available at -->
<!-- If the project is an API or a library, where can I find documentation for it? -->

crates.io (relastic)

## Requirements

- Rust or Nix and Direnv (this will install rust for you)

## More documentation

- `cargo doc --open` or [docs.rs](https://docs.rs/relastic/latest/relastic/)

## Testing locally

- `cargo test` in the main folder to run tests

## Known issues

- Needs to explicitly wait before closing sender since sender is non-blocking.
- No support for creating/updating templates from code
- HashMaps for mapping values
- We probably don't need to put sender behind RwLock (although the RwLock has no cap on readers)

## Usage

```rs
fn main() {
    let elastic_config = match elastic_config::ElasticConfig::new() {
        Ok(x) => x,
        Err(err) => panic!("Elastic not/improperly configured: {:?}", err),
    };
    log::setup_elastic_log(
        elastic_config,
        100,
    );

    /* ... */

    log::flush();
}
```

## Usage with Rocket.rs

[Rocket](https://rocket.rs) by default does not allow blocking services to run in it's `Tokio` runtime. It does have a functionality for running blocking tasks as async, but the logging service should hold precendence over it; If rocket panics, the logger should be able to log this before the application terminates.

Here's how you can setup relastic with Rocket:

```rs
fn main() {
    let elastic_config = match elastic_config::ElasticConfig::new() {
        Ok(x) => x,
        Err(err) => panic!("Elastic not/improperly configured: {:?}", err),
    };
    log::setup_elastic_log(
        elastic_config,
        100,
    );
    // Create multi-threaded tokio runtime for rocket
    let rt = tokio::runtime::Runtime::new().unwrap();
    rt.block_on(async {
        rocket_main().await;
    });
    log::flush();
}
```

This also makes it so that we don't have to rely on Rocket-specific dependencies.

## How to log

```rs
pub fn my_fn()
{
    log::information(
        "Got the following message: {message}",
        HashMap::from([
            ("message", "Hello World!".to_string())
        ])
    );
}
```

## Contributing

You are welcome to reports bugs, contribute code or open issues.
