# Relastic

Simple rust lib inspired by Serilog for application-wide logging:

- Application wide logs
- Posting logs to Elastic to access them with Kibana

## Purpose

<!-- What does the application do and why? What problem does it solve? -->

Log to Elastic from Rust applications

## Intended consumers

<!--  Who is the application intended for, and who can utilize its features? -->

Everyone. Do not use in production without first assessing the risks involved first.

## Main technologies

<!-- What are the main languages and frameworks are used in the project -->

Rust
NixShell

## Available at

<!-- If the application is live, mention where it can be 'viewed' and where it is deployed, e.g. OpenShift, Azure etc. -->
<!-- For libraries, this might also include what package repository it's available at -->
<!-- If the project is an API or a library, where can I find documentation for it? -->

crates.io (relastic)

## Requirements

- Rust or Nix and Direnv (this will install rust for you)

## More documentation

- `cargo doc --open`

## Testing locally

- `cargo test` in the main folder to run tests

## Known issues

- Needs to explicitly wait before closing sender since sender is non-blocking.
- Uses Reqwest::blocking
- No support for creating/updating templates from code

## Usage

```rs
fn main() {
    let elastic_config = match elastic_config::ElasticConfig::new() {
        Ok(x) => x,
        Err(err) => panic!("Elastic not/improperly configured: {:?}", err),
    };
    log::setup_elastic_log(
        elastic_config,
        100,
    );

    /* ... */

    log::flush();
}
```

## Usage with Rocket.rs

[Rocket](https://rocket.rs) does not allow blocking services to run in it's `Tokio` runtime. We were unable to discover an easy for solution to create a globally available logging function, without being fully dependent on `Rocket` dependencies. To use it with `Rocket` thefore requires you to define your own `Tokio` runtime instead of relying on `Rocket` setup magic.

Here's how you may do it:

```rs
fn main() {
    let elastic_config = match elastic_config::ElasticConfig::new() {
        Ok(x) => x,
        Err(err) => panic!("Elastic not/improperly configured: {:?}", err),
    };
    log::setup_elastic_log(
        elastic_config,
        100,
    );
    // Create multi-threaded tokio runtime for rocket
    let rt = tokio::runtime::Runtime::new().unwrap();
    rt.block_on(async {
        rocket_main().await;
    });
    log::flush();
}
```

## Contributing

You are welcome to reports bugs, contribute code or open issues.
