//! complex number library

use std::fmt;
use std::ops::Add;

/// complex number definition.
#[derive(Debug, PartialEq)]
pub struct Complex(pub u64, pub u64);

// According to https://doc.rust-lang.org/std/fmt/trait.Display.html
// Display is similar to Debug, but Display is for user-facing output, and so cannot be derived.
impl fmt::Display for Complex {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "({}, {}i)", self.0, self.1)
    }
}

impl Add for Complex {
    type Output = Self;

    fn add(self, other: Self) -> Self {
        Self(
            self.0 + other.0,
            self.1 + other.1,
        )
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }

    #[test]
    fn add_works() {
        assert_eq!(Complex(1, 2) + Complex(3, 4), Complex(4, 6));
    }
}
