//! complex number library

use std::fmt;

/// complex number definition.
#[derive(Debug)]
pub struct Complex(pub u64, pub u64);

// According to https://doc.rust-lang.org/std/fmt/trait.Display.html
// Display is similar to Debug, but Display is for user-facing output, and so cannot be derived.
impl fmt::Display for Complex {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "({}, {}i)", self.0, self.1)
    }
}

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
