/// This file is autogenerated from gen-folds.rs and CaseFolding.txt.

pub struct FoldRange {
    /// The first codepoint in the range.
    pub start: u32,

    /// The length of the range, in code points.
    pub length: u8,

    /// The (signed) delta amount.
    /// Folds are performed by adding this (signed) value to a code point.
    pub delta: i32,

    /// The modulo amount.
    /// Folds are only performed if the code point is a multiple of this value.
    pub modulo: u8,
}

const fn fr(start: u32, length: u8, delta: i32, modulo: u8) -> FoldRange {
    FoldRange {
        start,
        length,
        delta,
        modulo,
    }
}

pub static FOLDS: [FoldRange; 194] = [
    fr(0x41, 26, 32, 1),
    fr(0xB5, 1, 775, 1),
    fr(0xC0, 23, 32, 1),
    fr(0xD8, 7, 32, 1),
    fr(0x100, 47, 1, 2),
    fr(0x132, 5, 1, 2),
    fr(0x139, 15, 1, 2),
    fr(0x14A, 45, 1, 2),
    fr(0x178, 1, -121, 1),
    fr(0x179, 5, 1, 2),
    fr(0x17F, 1, -268, 1),
    fr(0x181, 1, 210, 1),
    fr(0x182, 3, 1, 2),
    fr(0x186, 1, 206, 1),
    fr(0x187, 1, 1, 1),
    fr(0x189, 2, 205, 1),
    fr(0x18B, 1, 1, 1),
    fr(0x18E, 1, 79, 1),
    fr(0x18F, 1, 202, 1),
    fr(0x190, 1, 203, 1),
    fr(0x191, 1, 1, 1),
    fr(0x193, 1, 205, 1),
    fr(0x194, 1, 207, 1),
    fr(0x196, 1, 211, 1),
    fr(0x197, 1, 209, 1),
    fr(0x198, 1, 1, 1),
    fr(0x19C, 1, 211, 1),
    fr(0x19D, 1, 213, 1),
    fr(0x19F, 1, 214, 1),
    fr(0x1A0, 5, 1, 2),
    fr(0x1A6, 1, 218, 1),
    fr(0x1A7, 1, 1, 1),
    fr(0x1A9, 1, 218, 1),
    fr(0x1AC, 1, 1, 1),
    fr(0x1AE, 1, 218, 1),
    fr(0x1AF, 1, 1, 1),
    fr(0x1B1, 2, 217, 1),
    fr(0x1B3, 3, 1, 2),
    fr(0x1B7, 1, 219, 1),
    fr(0x1B8, 5, 1, 4),
    fr(0x1C4, 1, 2, 1),
    fr(0x1C5, 1, 1, 1),
    fr(0x1C7, 1, 2, 1),
    fr(0x1C8, 1, 1, 1),
    fr(0x1CA, 1, 2, 1),
    fr(0x1CB, 17, 1, 2),
    fr(0x1DE, 17, 1, 2),
    fr(0x1F1, 1, 2, 1),
    fr(0x1F2, 3, 1, 2),
    fr(0x1F6, 1, -97, 1),
    fr(0x1F7, 1, -56, 1),
    fr(0x1F8, 39, 1, 2),
    fr(0x220, 1, -130, 1),
    fr(0x222, 17, 1, 2),
    fr(0x23A, 1, 10795, 1),
    fr(0x23B, 1, 1, 1),
    fr(0x23D, 1, -163, 1),
    fr(0x23E, 1, 10792, 1),
    fr(0x241, 1, 1, 1),
    fr(0x243, 1, -195, 1),
    fr(0x244, 1, 69, 1),
    fr(0x245, 1, 71, 1),
    fr(0x246, 9, 1, 2),
    fr(0x345, 1, 116, 1),
    fr(0x370, 3, 1, 2),
    fr(0x376, 1, 1, 1),
    fr(0x37F, 1, 116, 1),
    fr(0x386, 1, 38, 1),
    fr(0x388, 3, 37, 1),
    fr(0x38C, 1, 64, 1),
    fr(0x38E, 2, 63, 1),
    fr(0x391, 17, 32, 1),
    fr(0x3A3, 9, 32, 1),
    fr(0x3C2, 1, 1, 1),
    fr(0x3CF, 1, 8, 1),
    fr(0x3D0, 1, -30, 1),
    fr(0x3D1, 1, -25, 1),
    fr(0x3D5, 1, -15, 1),
    fr(0x3D6, 1, -22, 1),
    fr(0x3D8, 23, 1, 2),
    fr(0x3F0, 1, -54, 1),
    fr(0x3F1, 1, -48, 1),
    fr(0x3F4, 1, -60, 1),
    fr(0x3F5, 1, -64, 1),
    fr(0x3F7, 1, 1, 1),
    fr(0x3F9, 1, -7, 1),
    fr(0x3FA, 1, 1, 1),
    fr(0x3FD, 3, -130, 1),
    fr(0x400, 16, 80, 1),
    fr(0x410, 32, 32, 1),
    fr(0x460, 33, 1, 2),
    fr(0x48A, 53, 1, 2),
    fr(0x4C0, 1, 15, 1),
    fr(0x4C1, 13, 1, 2),
    fr(0x4D0, 95, 1, 2),
    fr(0x531, 38, 48, 1),
    fr(0x10A0, 38, 7264, 1),
    fr(0x10C7, 7, 7264, 6),
    fr(0x13F8, 6, -8, 1),
    fr(0x1C80, 1, -6222, 1),
    fr(0x1C81, 1, -6221, 1),
    fr(0x1C82, 1, -6212, 1),
    fr(0x1C83, 2, -6210, 1),
    fr(0x1C85, 1, -6211, 1),
    fr(0x1C86, 1, -6204, 1),
    fr(0x1C87, 1, -6180, 1),
    fr(0x1C88, 1, 35267, 1),
    fr(0x1C90, 43, -3008, 1),
    fr(0x1CBD, 3, -3008, 1),
    fr(0x1E00, 149, 1, 2),
    fr(0x1E9B, 1, -58, 1),
    fr(0x1E9E, 1, -7615, 1),
    fr(0x1EA0, 95, 1, 2),
    fr(0x1F08, 8, -8, 1),
    fr(0x1F18, 6, -8, 1),
    fr(0x1F28, 8, -8, 1),
    fr(0x1F38, 8, -8, 1),
    fr(0x1F48, 6, -8, 1),
    fr(0x1F59, 7, -8, 2),
    fr(0x1F68, 8, -8, 1),
    fr(0x1F88, 8, -8, 1),
    fr(0x1F98, 8, -8, 1),
    fr(0x1FA8, 8, -8, 1),
    fr(0x1FB8, 2, -8, 1),
    fr(0x1FBA, 2, -74, 1),
    fr(0x1FBC, 1, -9, 1),
    fr(0x1FBE, 1, -7173, 1),
    fr(0x1FC8, 4, -86, 1),
    fr(0x1FCC, 1, -9, 1),
    fr(0x1FD8, 2, -8, 1),
    fr(0x1FDA, 2, -100, 1),
    fr(0x1FE8, 2, -8, 1),
    fr(0x1FEA, 2, -112, 1),
    fr(0x1FEC, 1, -7, 1),
    fr(0x1FF8, 2, -128, 1),
    fr(0x1FFA, 2, -126, 1),
    fr(0x1FFC, 1, -9, 1),
    fr(0x2126, 1, -7517, 1),
    fr(0x212A, 1, -8383, 1),
    fr(0x212B, 1, -8262, 1),
    fr(0x2132, 1, 28, 1),
    fr(0x2160, 16, 16, 1),
    fr(0x2183, 1, 1, 1),
    fr(0x24B6, 26, 26, 1),
    fr(0x2C00, 47, 48, 1),
    fr(0x2C60, 1, 1, 1),
    fr(0x2C62, 1, -10743, 1),
    fr(0x2C63, 1, -3814, 1),
    fr(0x2C64, 1, -10727, 1),
    fr(0x2C67, 5, 1, 2),
    fr(0x2C6D, 1, -10780, 1),
    fr(0x2C6E, 1, -10749, 1),
    fr(0x2C6F, 1, -10783, 1),
    fr(0x2C70, 1, -10782, 1),
    fr(0x2C72, 4, 1, 3),
    fr(0x2C7E, 2, -10815, 1),
    fr(0x2C80, 99, 1, 2),
    fr(0x2CEB, 3, 1, 2),
    fr(0x2CF2, 1, 1, 1),
    fr(0xA640, 45, 1, 2),
    fr(0xA680, 27, 1, 2),
    fr(0xA722, 13, 1, 2),
    fr(0xA732, 61, 1, 2),
    fr(0xA779, 3, 1, 2),
    fr(0xA77D, 1, -35332, 1),
    fr(0xA77E, 9, 1, 2),
    fr(0xA78B, 1, 1, 1),
    fr(0xA78D, 1, -42280, 1),
    fr(0xA790, 3, 1, 2),
    fr(0xA796, 19, 1, 2),
    fr(0xA7AA, 1, -42308, 1),
    fr(0xA7AB, 1, -42319, 1),
    fr(0xA7AC, 1, -42315, 1),
    fr(0xA7AD, 1, -42305, 1),
    fr(0xA7AE, 1, -42308, 1),
    fr(0xA7B0, 1, -42258, 1),
    fr(0xA7B1, 1, -42282, 1),
    fr(0xA7B2, 1, -42261, 1),
    fr(0xA7B3, 1, 928, 1),
    fr(0xA7B4, 11, 1, 2),
    fr(0xA7C2, 1, 1, 1),
    fr(0xA7C4, 1, -48, 1),
    fr(0xA7C5, 1, -42307, 1),
    fr(0xA7C6, 1, -35384, 1),
    fr(0xA7C7, 3, 1, 2),
    fr(0xA7F5, 1, 1, 1),
    fr(0xAB70, 80, -38864, 1),
    fr(0xFF21, 26, 32, 1),
    fr(0x10400, 40, 40, 1),
    fr(0x104B0, 36, 40, 1),
    fr(0x10C80, 51, 64, 1),
    fr(0x118A0, 32, 32, 1),
    fr(0x16E40, 32, 32, 1),
    fr(0x1E900, 34, 34, 1),
];
