# Refinery Cli

Run Refinery migrations via cli.

## Installation
Install refinery_cli via cargo.

```sh
cargo install refinery_cli
```

## Usage
Setup your database type and access credentials with `setup`.

```sh
refinery setup
```

After that, just run your migrations giving your config file with `-c` flag (by defaults it is the `refinery.toml` generated by the setup) and migrations dir with `files -p $dir`.

```sh
refinery migrate -c sqlite_refinery.toml -p ./sql_migrations
```

### Running via database uri

To run migrations from a database [uri](http://www.postgresql.org/docs/current/static/libpq-connect.html#LIBPQ-CONNSTRING) (like: postgres://user_name:passwd@hostname:5432/myDB ) stored in an environment variable DB_URI.

```sh
refinery migrate -e DB_URI -p ./sql_migrations
```
This option is also useful when running refinery inside a docker container, where you usually have the db connection info stored as an environment variable.  


For more info and migration options run.

```sh
refinery migrate --help
```
