use anyhow::Result;
use reef::Command;
use std::fs::File;
use std::io::Write;
use std::thread;
use std::time::Duration;

fn main() -> Result<()> {
    let command = Command::new("git").arg("--version").exec()?;
    println!("{:#?}", command);

    let c2 = Command::new("git")
        .arg("log")
        .arg("-1")
        .current_dir(&std::env::current_dir().unwrap())
        .exec()?;
    println!("{:#?}", c2);

    let c3 = Command::new("ftp").timeout(Duration::new(0, 0)).exec()?;
    println!("{:#?}", c3);

    // rake
    let rake_dir = std::env::temp_dir().join("reef.command.rake");
    if !rake_dir.exists() {
        std::fs::create_dir_all(&rake_dir)?;
    }
    let rakefile = rake_dir.join("rakefile.rb");
    let mut file = File::create(&rakefile)?;
    file.write_all(b"task :default do\nputs 'Hello'\nend")?;
    file.flush()?;
    thread::sleep(Duration::from_millis(500));
    let rake = Command::new("rake")
        .arg("default")
        .current_dir(&rake_dir)
        .exec()?;
    println!("{:#?}", rake);
    std::fs::remove_file(&rakefile)?;
    std::fs::remove_dir_all(&rake_dir)?;
    Ok(())
}
