#[cfg(test)]
use reef::Command;
use std::collections::VecDeque;

#[test]
fn command_history() {
    let mut history = VecDeque::<Command>::new();
    let git_version = Command::new("git --version").exec().unwrap();
    history.push_front(git_version);
    assert_eq!(1, history.len());
    match history.get(0) {
        Some(item) => {
            assert_eq!("git", item.name);
        }
        None => {
            assert!(false, "no history item found");
        }
    }
}
