use reef::Secrets;
use std::path::PathBuf;

fn main() {
    let path = PathBuf::from("target/secrets.db");
    if path.exists() {
        std::fs::remove_file(&path).unwrap();
    }
    let mut secrets = Secrets::new("target/secrets.db", "password");
    secrets.set("test", "abc");
    match secrets.save() {
        Ok(_) => {}
        Err(e) => {
            println!("{:?}", e);
            assert!(false, "{:?}", e);
        }
    }
    assert!(path.exists(), "path {:?} does not exist", &path);

    let secrets2 = Secrets::new("target/secrets.db", "password");
    assert_eq!("abc", secrets2.get("test").unwrap());
}
