/*use juniper::{FieldResult, Variables};
use reef::{Command, Commands};
use std::cell::RefCell;
use std::convert::TryFrom;
use std::convert::TryInto;*/

fn main() {}
/*
struct Context {
    commands: RefCell<Commands>,
}
impl juniper::Context for Context {}

struct Query;
#[juniper::object(Context=Context)]
impl Query {
    fn len(context: &Context) -> FieldResult<i32> {
        Ok(context.commands.borrow().history.len().try_into().unwrap())
    }

    fn command(context: &Context, index: i32) -> FieldResult<Command> {
        Ok(context.commands.borrow().history[usize::try_from(index)?].clone())
    }
}

struct Mutation;
#[juniper::object(
    Context = Context,
)]
impl Mutation {
    fn exec(context: &Context, command: String) -> FieldResult<Command> {
        // RefCell<T> and the Interior Mutability Pattern
        // https://doc.rust-lang.org/book/ch15-05-interior-mutability.html
        let command = context.commands.borrow_mut().exec(&command);
        Ok(command)
    }
}

fn main() {
    let mut commands = Commands::new();
    commands.exec("git --version");

    let context = Context {
        commands: RefCell::new(commands),
    };

    //let schema = juniper::RootNode::new(Query, EmptyMutation::<Context>::new());
    let schema = juniper::RootNode::new(Query, Mutation);
    let variables = Variables::new();

    // Run the executor.
    let (res, _errors) =
        juniper::execute("query { len } ", None, &schema, &variables, &context).unwrap();

    let obj = res.as_object_value().unwrap();
    let json = serde_json::to_string_pretty(&obj).unwrap();
    println!("{}", json);

    // Run the executor.command
    let (res, _errors) = juniper::execute(
        "query { command(index: 0) { name, stdout, env{ username}} } ",
        None,
        &schema,
        &variables,
        &context,
    )
    .unwrap();

    let obj = res.as_object_value().unwrap();
    let json = serde_json::to_string_pretty(&obj).unwrap();
    println!("{}", json);

    // Run the executor.command for a mutation
    let (res, _errors) = juniper::execute(
        "mutation { exec(command: \"cargo --version\") { name, stdout, env{ username}} } ",
        None,
        &schema,
        &variables,
        &context,
    )
    .unwrap();

    let obj = res.as_object_value().unwrap();
    let json = serde_json::to_string_pretty(&obj).unwrap();
    println!("{}", json);
}
*/
