use reef::Commands;

fn main() {
    let rakefile_path = std::env::temp_dir().join("rakefile.rb");
    std::fs::write(&rakefile_path, "task :default do puts 'hello rake' end").unwrap();
    let mut commands = Commands::new();
    commands
        .exec(&["git --version", "cargo --version", "ruby --version"])
        .unwrap();
    assert_eq!(3, commands.history.len());

    let find = commands.find("git");
    assert_eq!(1, find.len());
    println!("{}", &commands);
    commands.remove("git");
    assert_eq!(2, commands.history.len());
    commands.remove("cargo");
    assert_eq!(1, commands.history.len());
}
