use anyhow::Result;
use reef::Command;

fn main() -> Result<()> {
    let path = std::env::temp_dir().join("command-times.json");
    println!("path {}", path.display());

    if false {
        if path.exists() {
            std::fs::remove_file(&path)?;
        }
    }

    if path.exists() {
        println!("path exists, loading command...");
        let command = Command::open(&path)?;
        println!("command start {}", command.start_local().to_string());
        println!("command end   {}", command.end_local().to_string());

        let cloned = command.clone();
        println!("cloned start {}", cloned.start_local().to_string());
    } else {
        println!("path does not exists, saving command...");
        let command = Command::new("git --version").exec()?;
        println!("command start {}", command.start_local().to_string());
        command.save(&path)?;
    }
    Ok(())
}
