use anyhow::Result;
use log::Level;
use reef::{Command, Log};

fn main() -> Result<()> {
    Log::new()
        .level(Level::Trace)
        .format(Log::target_format)
        .init()?;

    Command::new("git --version").exec()?;
    //assert_eq!(git_version.status, Status::Ok);
    //assert!(git_version.stdout.contains("git version"));
    //let dir = PathBuf::from(&git_version.dir);
    //assert!(dir.exists(), "dir");

    Command::new("cargo version").exec()?;
    Command::new("cargo bad_command").exec()?;
    /*
    let cargo_version = Command::new("cargo version").exec().unwrap();
    println!("{}", cargo_version);

    match Command::new("cargo bad_command")
        .exec()
        .unwrap()
        .expect_exit_code(0)
    {
        Err(e) => println!("{}", e),
        Ok(c) => panic!("did not expect 'cargo bad_command' to work {}", c),
    }

    let path = std::env::temp_dir().join("command-test");
    if !path.exists() {
        std::fs::create_dir_all(&path).unwrap();
    }
    let repo_path = &path.join("raykit.git");
    if repo_path.exists() {
        Paths::clobber(&repo_path).unwrap();
    }

    match Command::new("git clone https://gitlab.com/gems-rb/raykit.git raykit.git")
        .directory(&path)
        .exec()
        //.exec_in(&path)
        .unwrap()
        .expect_exit_code(0)
    {
        Err(e) => panic!("{}", e),
        Ok(c) => {
            let command = c.clone();
            println!("{}", command);
            println!("exit code {}", command.exit_code);
            println!("stdout len {}", command.stdout.len());
            println!("stderr len {}", command.stderr.len());
            println!("start time {}", command.start_utc());

            println!("{}", "pretty debug".yellow());
            println!("{:#?}", &command);
            println!("{}", "debug".yellow());
            println!("{:?}", &command);
            println!("{}", "display".yellow());
            println!("{}", &command);
            println!("{}", "summary".yellow());
            println!("{}", &command.summary());
            println!("{}", "details".yellow());
            println!("{}", &command.details());
        }
    };

    assert!(
        repo_path.exists(),
        "{} does not exist",
        &repo_path.display()
    );

    println!("cleaning up {}", &repo_path.display());
    Paths::clobber(&repo_path).unwrap();
    */
    Ok(())
}
