#[cfg(test)]
use reef::{Command, Status};
use std::fs::File;
use std::io::Write;
use std::path::PathBuf;
use tempdir::TempDir;

#[test]
fn exec_test() {
    let git_version = Command::new("git --version").exec().unwrap();
    assert_eq!(git_version.status, Status::Ok);
    assert!(git_version.stdout.contains("git version"));
    let dir = PathBuf::from(git_version.working_dir);
    assert!(dir.exists(), "dir");
}

#[test]
fn exec_rake_test() -> std::io::Result<()> {
    let tmp_dir = TempDir::new("rake_test")?;
    let rakefile_content = include_str!("rakefile.rb");
    match reef::Env::which("rake") {
        Ok(_rake_path) => {
            let rakefile_path = tmp_dir.path().join("rakefile.rb");
            {
                let mut rakefile = File::create(&rakefile_path)?;
                rakefile.write_all(rakefile_content.as_bytes())?;
            }

            assert!(&rakefile_path.exists());

            let cmd = "rake default".to_string();
            let rake_default = Command::new(&cmd)
                .directory(&tmp_dir.path())
                .exec()
                .unwrap(); //exec_in(&tmp_dir.path()).unwrap();
            assert_eq!(rake_default.status, Status::Ok, "{:?}", rake_default);
            assert!(rake_default.stdout.contains("default"));
        }
        Err(_) => {}
    };
    tmp_dir.close()?;
    Ok(())
}

#[test]
fn unknown_command() {
    match Command::new("unknown").exec() {
        Ok(_) => panic!("did not expect 'unknown' to exec with an Error"),
        Err(e) => println!("{}", e),
    }
}
