use serde::{Deserialize, Serialize};

#[derive(Debug, Serialize, Deserialize, Clone, Hash, PartialEq, Eq)]
pub enum Status {
    Unknown,
    Ok,
    Error,
    Warning,
}

impl Status {
    pub fn symbol(&self) -> String {
        match self {
            Status::Unknown => format!("{}", "?"),
            Status::Warning => format!("{}", "!"),
            Status::Ok => format!("{}", "✓"),
            Status::Error => format!("{}", "X"),
        }
    }
}

impl Default for Status {
    fn default() -> Self {
        Status::Unknown
    }
}
