/*!
This crate provides a library for executing system commands.

# Usage

This crate is [on crates.io](https://crates.io/crates/reef) and can be
used by adding `reef` to your dependencies in your project's `Cargo.toml`.

```toml
[dependencies]
reef = "0"
```

If you're using Rust 2015, then you'll also need to add it to your crate root:

```rust
extern crate reef;
```

# Example: execute a command that is in the system PATH

note: git must be available in the system PATH for this example to work.

```rust
use reef::Command;
let git_version = Command::new("git --version").exec().unwrap();
assert!(git_version.stdout.contains("git version"));
```

*/

#![crate_name = "reef"]

#[macro_use]
extern crate error_chain;
pub mod duration;
pub use crate::duration::Duration;
mod errors;
pub use crate::errors::Error;
pub use crate::errors::ErrorKind;
pub use crate::errors::Result;

mod log;
pub use crate::log::Log;

//mod spinner;
//pub use crate::spinner::Spinner;

mod secrets;
pub use crate::secrets::Secrets;

mod paths;
pub use crate::paths::Paths;
mod text;

mod status;
pub use crate::status::Status;

mod env;
pub use crate::env::Env;

mod command;
pub use crate::command::Command;

mod commands;
pub use crate::commands::Commands;
